/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.HashMap;
import java.util.Map;

public enum AxisDirectionType {
    AFT("aft"),
    AWAY_FROM("awayFrom"),
    CLOCKWISE("clockwise"),
    COLUMN_NEGATIVE("columnNegative"),
    COLUMN_POSITIVE("columnPositive"),
    COUNTER_CLOCKWISE("counterClockwise"),
    DISPLAY_DOWN("displayDown"),
    DISPLAY_LEFT("displayLeft"),
    DISPLAY_RIGHT("displayRight"),
    DISPLAY_UP("displayUp"),
    DOWN("down"),
    EAST("east"),
    EAST_NORTH_EAST("eastNorthEast"),
    EAST_SOUTH_EAST("eastSouthEast"),
    FORWARD("forward"),
    FUTURE("future"),
    GEOCENTRIC_X("geocentricX"),
    GEOCENTRIC_Y("geocentricY"),
    GEOCENTRIC_Z("geocentricZ"),
    NORTH("north"),
    NORTH_EAST("northEast"),
    NORTH_NORTH_EAST("northNorthEast"),
    NORTH_NORTH_WEST("northNorthWest"),
    NORTH_WEST("northWest"),
    PAST("past"),
    PORT("port"),
    ROW_NEGATIVE("rowNegative"),
    ROW_POSITIVE("rowPositive"),
    SOUTH("south"),
    SOUTH_EAST("southEast"),
    SOUTH_SOUTH_EAST("southSouthEast"),
    SOUTH_SOUTH_WEST("southSouthWest"),
    SOUTH_WEST("southWest"),
    STARBOARD("starboard"),
    TOWARDS("towards"),
    UNSPECIFIED("unspecified"),
    UP("up"),
    WEST("west"),
    WEST_NORTH_WEST("westNorthWest"),
    WEST_SOUTH_WEST("westSouthWest");

    private static final Map<String, AxisDirectionType> nameTypes;
    private final String name;

    private AxisDirectionType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static AxisDirectionType getType(String name) {
        AxisDirectionType type = null;
        if (name != null) {
            type = nameTypes.get(name.toUpperCase());
        }
        return type;
    }

    static {
        nameTypes = new HashMap<String, AxisDirectionType>();
        for (AxisDirectionType type : AxisDirectionType.values()) {
            nameTypes.put(type.getName().toUpperCase(), type);
        }
    }
}

