/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.google.common.net.InetAddresses;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.ProducesJson;
import java.net.InetAddress;
import java.util.List;
import java.util.Optional;
import org.apache.baremaps.iploc.IpLocObject;
import org.apache.baremaps.iploc.IpLocRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpLocResource {
    private static final Logger logger = LoggerFactory.getLogger(IpLocResource.class);
    private final IpLocRepository ipLocRepository;

    public IpLocResource(IpLocRepository ipLocRepository) {
        this.ipLocRepository = ipLocRepository;
    }

    @Get(value="/api/ip")
    @ProducesJson
    public HttpResponse ip(ServiceRequestContext context, HttpHeaders requestHeaders, @Param(value="ip") String ip) {
        try {
            InetAddress address = InetAddresses.forString((String)((CharSequence)Optional.ofNullable(ip).or(() -> Optional.ofNullable(requestHeaders.get((CharSequence)"X-Forwarded-For"))).or(() -> Optional.ofNullable(requestHeaders.get((CharSequence)"X-Real-IP"))).orElse(context.remoteAddress().getAddress().getHostAddress())).toString().split(",")[0].trim());
            ResponseHeaders responseHeaders = ResponseHeaders.builder((int)200).add((CharSequence)"Content-Type", "application/json").add((CharSequence)"Access-Control-Allow-Origin", "*").build();
            return HttpResponse.ofJson((ResponseHeaders)responseHeaders, (Object)new IP(address.toString()));
        }
        catch (IllegalArgumentException e) {
            logger.error("Error while processing request", (Throwable)e);
            return HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Get(value="/api/iploc")
    @ProducesJson
    public Response iploc(ServiceRequestContext context, HttpHeaders requestHeaders, @Param(value="ip") String ip) {
        try {
            InetAddress address = InetAddresses.forString((String)((CharSequence)Optional.ofNullable(ip).or(() -> Optional.ofNullable(requestHeaders.get((CharSequence)"X-Forwarded-For"))).or(() -> Optional.ofNullable(requestHeaders.get((CharSequence)"X-Real-IP"))).orElse(context.remoteAddress().getAddress().getHostAddress())).toString().split(",")[0].trim());
            List inetnumLocations = this.ipLocRepository.findByInetAddress(address);
            List<InetnumLocationDto> inetnumLocationDtos = inetnumLocations.stream().map(InetnumLocationDto::new).toList();
            ResponseHeaders responseHeaders = ResponseHeaders.builder((int)200).add((CharSequence)"Content-Type", "application/json").add((CharSequence)"Access-Control-Allow-Origin", "*").build();
            return HttpResponse.ofJson((ResponseHeaders)responseHeaders, inetnumLocationDtos);
        }
        catch (IllegalArgumentException e) {
            logger.error("Error while processing request", (Throwable)e);
            return HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public record IP(String ip) {
    }

    public record InetnumLocationDto(String geocoderInput, String inetStart, String inetEnd, double longitude, double latitude, String network, String country, String source, String precision) {
        public InetnumLocationDto(IpLocObject ipLocObject) {
            this(ipLocObject.geocoderInput(), ipLocObject.inetRange().start().toString().substring(1), ipLocObject.inetRange().end().toString().substring(1), ipLocObject.coordinate().getX(), ipLocObject.coordinate().getY(), ipLocObject.network(), ipLocObject.country(), ipLocObject.source(), ipLocObject.precision().toString());
        }
    }
}

