/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.csv;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.baremaps.csv.CsvDataTable;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataStore;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;

public class CsvDataStore
implements DataStore {
    private final String tableName;
    private final DataSchema schema;
    private final CsvDataTable dataTable;

    public CsvDataStore(String tableName, DataSchema schema, File csvFile, boolean hasHeader, char separator) throws IOException {
        this.tableName = tableName;
        this.schema = schema;
        this.dataTable = new CsvDataTable(schema, csvFile, hasHeader, separator);
    }

    public List<String> list() throws DataStoreException {
        return Collections.singletonList(this.tableName);
    }

    public DataTable get(String name) throws DataStoreException {
        if (this.tableName.equals(name)) {
            return this.dataTable;
        }
        throw new DataStoreException("Table '" + name + "' not found.");
    }

    public void add(DataTable table) throws DataStoreException {
        throw new UnsupportedOperationException("Adding tables is not supported in CsvDataStore.");
    }

    public void add(String name, DataTable table) throws DataStoreException {
        throw new UnsupportedOperationException("Adding tables is not supported in CsvDataStore.");
    }

    public void remove(String name) throws DataStoreException {
        throw new UnsupportedOperationException("Removing tables is not supported in CsvDataStore.");
    }
}

