/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.rpsl;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.baremaps.rpsl.RpslObject;
import org.apache.baremaps.rpsl.RpslReader;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;

class RpslDataRowIterator
implements Iterator<DataRow> {
    private final Iterator<RpslObject> rpslObjectIterator;
    private final DataSchema schema;

    public RpslDataRowIterator(InputStream inputStream, DataSchema schema) {
        this.schema = schema;
        RpslReader rpslReader = new RpslReader();
        this.rpslObjectIterator = rpslReader.read(inputStream).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.rpslObjectIterator.hasNext();
    }

    @Override
    public DataRow next() {
        RpslObject rpslObject = this.rpslObjectIterator.next();
        return this.createDataRow(rpslObject);
    }

    private DataRow createDataRow(RpslObject rpslObject) {
        DataRow dataRow = this.schema.createRow();
        for (DataColumn column : this.schema.columns()) {
            String columnName = column.name().toLowerCase();
            switch (column.cardinality()) {
                case REQUIRED: 
                case OPTIONAL: {
                    Object value = this.getSingleValue(rpslObject, column);
                    if (value == null) break;
                    dataRow.set(columnName, value);
                    break;
                }
                case REPEATED: {
                    List<String> values = this.getRepeatedValue(rpslObject, column);
                    if (values == null || values.isEmpty()) break;
                    dataRow.set(columnName, values);
                }
            }
        }
        return dataRow;
    }

    private Object getSingleValue(RpslObject rpslObject, DataColumn column) {
        String columnName = column.name().toLowerCase();
        return rpslObject.first(columnName).orElse(null);
    }

    private List<String> getRepeatedValue(RpslObject rpslObject, DataColumn column) {
        String columnName = column.name().toLowerCase();
        return rpslObject.all(columnName);
    }
}

