/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.system.CommonExecutor;
import org.apache.sis.util.Disposable;

final class MultiSourcePrefetch
implements Disposable {
    private final PlanarImage[] sources;
    private final Rectangle[] tileIndices;
    private int count;
    private Disposable[] cleaners;
    private int cleanerCount;
    private RuntimeException error;

    MultiSourcePrefetch(RenderedImage[] images, Rectangle aoi) {
        this.sources = new PlanarImage[images.length];
        this.tileIndices = new Rectangle[images.length];
        for (RenderedImage source : images) {
            if (!(source instanceof PlanarImage)) continue;
            Rectangle r = new Rectangle(aoi);
            ImageUtilities.clipBounds(source, r);
            r = ImageUtilities.pixelsToTiles(source, r);
            if (r.isEmpty()) continue;
            this.tileIndices[this.count] = r;
            this.sources[this.count++] = (PlanarImage)source;
        }
    }

    final Disposable run(boolean parallel) {
        switch (this.count) {
            case 0: {
                return null;
            }
            case 1: {
                parallel = false;
            }
        }
        Future[] workers = parallel ? new Future[this.count] : null;
        this.cleaners = new Disposable[this.count];
        for (int i = 0; i < this.count; ++i) {
            PlanarImage source = this.sources[i];
            Rectangle r = this.tileIndices[i];
            if (parallel) {
                Callable<Disposable> callable = () -> source.prefetch(r);
                workers[i] = CommonExecutor.instance().submit(callable);
                continue;
            }
            Disposable disposable = source.prefetch(r);
            if (disposable == null) continue;
            this.cleaners[this.cleanerCount++] = disposable;
        }
        if (parallel) {
            for (Future future : workers) {
                try {
                    Disposable cleaner = (Disposable)future.get();
                    if (cleaner == null) continue;
                    this.cleaners[this.cleanerCount++] = cleaner;
                }
                catch (Exception e) {
                    this.addError(e);
                    this.dispose();
                }
            }
        }
        switch (this.cleanerCount) {
            case 0: {
                return null;
            }
            case 1: {
                return this.cleaners[0];
            }
        }
        return this;
    }

    public void dispose() {
        for (int i = 0; i < this.cleanerCount; ++i) {
            try {
                this.cleaners[i].dispose();
                continue;
            }
            catch (Exception e) {
                this.addError(e);
            }
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    private void addError(Exception e) {
        if (this.error != null) {
            this.error.addSuppressed(e);
        } else {
            this.error = e instanceof RuntimeException ? (RuntimeException)e : (ImagingOpException)new ImagingOpException(e.getMessage()).initCause(e);
        }
    }
}

