/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.circuitbreaker;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RpcRequest;

public final class CircuitBreakerMappingUtil {
    public static String host(ClientRequestContext ctx) {
        Endpoint endpoint = ctx.endpoint();
        if (endpoint == null) {
            return "UNKNOWN";
        }
        String ipAddr = endpoint.ipAddr();
        if (ipAddr == null || endpoint.isIpAddrOnly()) {
            return endpoint.authority();
        }
        return endpoint.authority() + '/' + ipAddr;
    }

    public static String method(ClientRequestContext ctx) {
        RpcRequest rpcReq = ctx.rpcRequest();
        return rpcReq != null ? rpcReq.method() : ctx.method().name();
    }

    public static String path(ClientRequestContext ctx) {
        HttpRequest request = ctx.request();
        return request == null ? "" : request.path();
    }

    private CircuitBreakerMappingUtil() {
    }
}

