/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.referencing.util.CoordinateOperations;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.CollectionsExt;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;

public class CoordinateOperationContext
implements Serializable {
    private static final long serialVersionUID = -6944460471653277973L;
    private Extent areaOfInterest;
    private double desiredAccuracy;

    public CoordinateOperationContext() {
    }

    public CoordinateOperationContext(Extent area, double accuracy) {
        ArgumentChecks.ensurePositive((String)"accuracy", (double)accuracy);
        if (area != null) {
            this.areaOfInterest = new DefaultExtent(area);
        }
        this.desiredAccuracy = accuracy;
    }

    public static CoordinateOperationContext fromBoundingBox(GeographicBoundingBox areaOfInterest) {
        if (areaOfInterest != null && (areaOfInterest.getSouthBoundLatitude() > -90.0 || areaOfInterest.getNorthBoundLatitude() < 90.0 || areaOfInterest.getWestBoundLongitude() > -180.0 || areaOfInterest.getEastBoundLongitude() < 180.0)) {
            CoordinateOperationContext context = new CoordinateOperationContext();
            context.setAreaOfInterest(areaOfInterest);
            return context;
        }
        return null;
    }

    public Extent getAreaOfInterest() {
        return this.areaOfInterest;
    }

    public void setAreaOfInterest(Extent area) {
        if (area != null) {
            area = new DefaultExtent(area);
        }
        this.areaOfInterest = area;
    }

    public void setAreaOfInterest(GeographicBoundingBox area) {
        this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, area);
    }

    static Extent setGeographicBoundingBox(Extent areaOfInterest, GeographicBoundingBox bbox) {
        if (areaOfInterest != null) {
            DefaultExtent ex = DefaultExtent.castOrCopy((Extent)areaOfInterest);
            ex.setGeographicElements((Collection)CollectionsExt.singletonOrEmpty((Object)bbox));
            areaOfInterest = ex;
        } else if (bbox != null) {
            areaOfInterest = new DefaultExtent(null, (GeographicExtent)bbox, null, null);
        }
        return areaOfInterest;
    }

    public double getDesiredAccuracy() {
        return this.desiredAccuracy;
    }

    public void setDesiredAccuracy(double accuracy) {
        ArgumentChecks.ensurePositive((String)"accuracy", (double)accuracy);
        this.desiredAccuracy = accuracy;
    }

    final Predicate<CoordinateOperation> getOperationFilter() {
        return null;
    }

    static double[] getConstantCoordinates() throws TransformException {
        Supplier<double[]> f = CoordinateOperations.CONSTANT_COORDINATES.get();
        if (f != null) {
            try {
                return f.get();
            }
            catch (BackingStoreException e) {
                throw (TransformException)((Object)e.unwrapOrRethrow(TransformException.class));
            }
        }
        return null;
    }
}

