/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPassThroughOperation;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.referencing.util.CoordinateOperations;
import org.apache.sis.referencing.util.NilReferencingObject;
import org.apache.sis.referencing.util.PositionalAccuracyConstant;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractCoordinateOperationType", propOrder={"operationVersion", "accuracy", "source", "target"})
@XmlRootElement(name="AbstractCoordinateOperation")
@XmlSeeAlso(value={AbstractSingleOperation.class, DefaultPassThroughOperation.class, DefaultConcatenatedOperation.class})
public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = -5441746770453401219L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.operation");
    CoordinateReferenceSystem sourceCRS;
    CoordinateReferenceSystem targetCRS;
    private CoordinateReferenceSystem interpolationCRS;
    private String operationVersion;
    Collection<PositionalAccuracy> coordinateOperationAccuracy;
    MathTransform transform;
    private transient Set<Integer> wrapAroundChanges;

    AbstractCoordinateOperation(Map<String, ?> properties) {
        super(properties);
        this.operationVersion = (String)Containers.property(properties, (Object)"operationVersion", String.class);
        Object value = properties.get("coordinateOperationAccuracy");
        if (value != null) {
            this.coordinateOperationAccuracy = value instanceof PositionalAccuracy[] ? CollectionsExt.nonEmptySet((Object[])((PositionalAccuracy[])value)) : Set.of((PositionalAccuracy)value);
        }
    }

    public AbstractCoordinateOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, MathTransform transform) {
        this(properties);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.interpolationCRS = interpolationCRS;
        this.transform = transform;
        this.checkDimensions(properties);
    }

    final void checkDimensions(Map<String, ?> properties) {
        MathTransform transform = this.transform;
        if (transform != null) {
            int interpDim = ReferencingUtilities.getDimension(this.interpolationCRS);
            int isTarget = 0;
            block4: while (true) {
                int actual;
                CoordinateReferenceSystem crs;
                switch (isTarget) {
                    case 0: {
                        crs = this.sourceCRS;
                        actual = transform.getSourceDimensions();
                        break;
                    }
                    case 1: {
                        crs = this.targetCRS;
                        actual = transform.getTargetDimensions();
                        break;
                    }
                    default: {
                        break block4;
                    }
                }
                int expected = ReferencingUtilities.getDimension(crs);
                if (interpDim != 0) {
                    if (actual == expected || actual < interpDim) {
                        throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)41));
                    }
                    expected += interpDim;
                }
                if (crs != null && actual != expected) {
                    throw new IllegalArgumentException(Errors.getResources(properties).getString((short)190, (Object)super.getName().getCode(), (Object)isTarget, (Object)expected, (Object)actual));
                }
                ++isTarget;
            }
        }
        this.computeTransientFields();
    }

    final void computeTransientFields() {
        this.wrapAroundChanges = this.sourceCRS != null && this.targetCRS != null ? CoordinateOperations.wrapAroundChanges(this.sourceCRS, this.targetCRS.getCoordinateSystem()) : Set.of();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeTransientFields();
    }

    protected AbstractCoordinateOperation(CoordinateOperation operation) {
        super((IdentifiedObject)operation);
        this.sourceCRS = operation.getSourceCRS();
        this.targetCRS = operation.getTargetCRS();
        this.interpolationCRS = AbstractCoordinateOperation.getInterpolationCRS(operation);
        this.operationVersion = operation.getOperationVersion();
        this.coordinateOperationAccuracy = operation.getCoordinateOperationAccuracy();
        this.transform = operation.getMathTransform();
        if (operation instanceof AbstractCoordinateOperation) {
            this.wrapAroundChanges = ((AbstractCoordinateOperation)operation).wrapAroundChanges;
        } else {
            this.computeTransientFields();
        }
    }

    public static AbstractCoordinateOperation castOrCopy(CoordinateOperation object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends CoordinateOperation> getInterface() {
        return CoordinateOperation.class;
    }

    public boolean isDefiningConversion() {
        return this.sourceCRS == null && this.targetCRS == null || this.targetCRS instanceof GeneralDerivedCRS && ((GeneralDerivedCRS)this.targetCRS).getBaseCRS() == this.sourceCRS && ((GeneralDerivedCRS)this.targetCRS).getConversionFromBase() == this;
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public CoordinateReferenceSystem getInterpolationCRS() {
        return this.interpolationCRS;
    }

    static CoordinateReferenceSystem getInterpolationCRS(CoordinateOperation operation) {
        return operation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)operation).getInterpolationCRS() : null;
    }

    @XmlElement(name="operationVersion")
    public String getOperationVersion() {
        return this.operationVersion;
    }

    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        return CollectionsExt.nonNull(this.coordinateOperationAccuracy);
    }

    public double getLinearAccuracy() {
        return PositionalAccuracyConstant.getLinearAccuracy(this);
    }

    @Deprecated(since="1.4")
    public Extent getDomainOfValidity() {
        return Legacy.getDomainOfValidity(this.getDomains());
    }

    @Deprecated(since="1.4")
    public InternationalString getScope() {
        return Legacy.getScope(this.getDomains());
    }

    public MathTransform getMathTransform() {
        return this.transform;
    }

    OperationMethod getMethod() {
        return null;
    }

    ParameterDescriptorGroup getParameterDescriptors() {
        OperationMethod method;
        ParameterDescriptorGroup descriptor = AbstractCoordinateOperation.getParameterDescriptors(this.transform);
        if (descriptor == null && (method = this.getMethod()) != null) {
            descriptor = method.getParameters();
        }
        return descriptor;
    }

    static ParameterDescriptorGroup getParameterDescriptors(MathTransform transform) {
        while (transform != null) {
            if (transform instanceof Parameterized) {
                ParameterDescriptorGroup param;
                if (Semaphores.queryAndSet((int)8)) {
                    throw new AssertionError();
                }
                try {
                    param = ((Parameterized)transform).getParameterDescriptors();
                }
                finally {
                    Semaphores.clear((int)8);
                }
                if (param != null) {
                    return param;
                }
            }
            if (!(transform instanceof PassThroughTransform)) break;
            transform = ((PassThroughTransform)transform).getSubTransform();
        }
        return null;
    }

    ParameterValueGroup getParameterValues() throws UnsupportedOperationException {
        MathTransform mt = this.transform;
        while (mt != null) {
            if (mt instanceof Parameterized) {
                ParameterValueGroup param;
                if (Semaphores.queryAndSet((int)8)) {
                    throw new AssertionError();
                }
                try {
                    param = ((Parameterized)mt).getParameterValues();
                }
                finally {
                    Semaphores.clear((int)8);
                }
                if (param != null) {
                    return param;
                }
            }
            if (!(mt instanceof PassThroughTransform)) break;
            mt = ((PassThroughTransform)mt).getSubTransform();
        }
        throw new UnsupportedImplementationException(Classes.getClass((Object)mt));
    }

    public Set<Integer> getWrapAroundChanges() {
        return this.wrapAroundChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            if (mode == ComparisonMode.STRICT) {
                AbstractCoordinateOperation that = (AbstractCoordinateOperation)object;
                if (Objects.equals(this.sourceCRS, that.sourceCRS) && Objects.equals(this.interpolationCRS, that.interpolationCRS) && Objects.equals(this.transform, that.transform) && Objects.equals(this.coordinateOperationAccuracy, that.coordinateOperationAccuracy)) {
                    if (Semaphores.queryAndSet((int)4)) {
                        return true;
                    }
                    try {
                        boolean bl = Objects.equals(this.targetCRS, that.targetCRS);
                        return bl;
                    }
                    finally {
                        Semaphores.clear((int)4);
                    }
                }
            } else {
                CoordinateOperation that = (CoordinateOperation)object;
                if ((mode.isIgnoringMetadata() || Utilities.deepEquals(this.getCoordinateOperationAccuracy(), (Object)that.getCoordinateOperationAccuracy(), (ComparisonMode)mode)) && Utilities.deepEquals((Object)this.getInterpolationCRS(), (Object)AbstractCoordinateOperation.getInterpolationCRS(that), (ComparisonMode)mode)) {
                    CoordinateReferenceSystem crs2;
                    CoordinateReferenceSystem crs1;
                    boolean debug = false;
                    if (Semaphores.queryAndSet((int)4)) {
                        if (mode.isIgnoringMetadata()) {
                            debug = mode == ComparisonMode.DEBUG;
                            mode = ComparisonMode.ALLOW_VARIANT;
                        }
                    } else {
                        try {
                            if (!Utilities.deepEquals((Object)this.getTargetCRS(), (Object)that.getTargetCRS(), (ComparisonMode)mode)) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        finally {
                            Semaphores.clear((int)4);
                        }
                    }
                    if (Utilities.deepEquals((Object)(crs1 = this.getSourceCRS()), (Object)(crs2 = that.getSourceCRS()), (ComparisonMode)mode)) {
                        MathTransform tr1 = this.getMathTransform();
                        MathTransform tr2 = that.getMathTransform();
                        if (mode == ComparisonMode.ALLOW_VARIANT) {
                            try {
                                LinearTransform before = MathTransforms.linear(CoordinateSystems.swapAndScaleAxes(crs1.getCoordinateSystem(), crs2.getCoordinateSystem()));
                                LinearTransform after = MathTransforms.linear(CoordinateSystems.swapAndScaleAxes(that.getTargetCRS().getCoordinateSystem(), this.getTargetCRS().getCoordinateSystem()));
                                tr2 = MathTransforms.concatenate(before, tr2, after);
                            }
                            catch (RuntimeException | IncommensurableException e) {
                                Logging.ignorableException((Logger)LOGGER, AbstractCoordinateOperation.class, (String)"equals", (Throwable)e);
                            }
                        }
                        if (Utilities.deepEquals((Object)tr1, (Object)tr2, (ComparisonMode)mode)) {
                            return true;
                        }
                        assert (!debug || Utilities.deepEquals((Object)tr1, (Object)tr2, (ComparisonMode)ComparisonMode.DEBUG));
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.sourceCRS, this.targetCRS, this.interpolationCRS, this.transform);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        OperationMethod method;
        super.formatTo(formatter);
        formatter.newLine();
        CoordinateReferenceSystem sourceCRS = this.getSourceCRS();
        CoordinateReferenceSystem targetCRS = this.getTargetCRS();
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        FormattableObject enclosing = formatter.getEnclosingElement(1);
        boolean isSubOperation = enclosing instanceof PassThroughOperation;
        boolean isComponent = enclosing instanceof ConcatenatedOperation;
        boolean isGeogTran = false;
        if (!isSubOperation && !isComponent) {
            boolean bl = isGeogTran = isWKT1 && sourceCRS instanceof GeographicCRS && targetCRS instanceof GeographicCRS;
            if (isGeogTran) {
                formatter.append(WKTUtilities.toFormattable(sourceCRS));
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable(targetCRS));
                formatter.newLine();
            } else {
                AbstractCoordinateOperation.append(formatter, sourceCRS, "SourceCRS");
                AbstractCoordinateOperation.append(formatter, targetCRS, "TargetCRS");
            }
        }
        if ((method = this.getMethod()) != null) {
            ParameterValueGroup parameters;
            formatter.append(DefaultOperationMethod.castOrCopy(method));
            try {
                parameters = this.getParameterValues();
            }
            catch (UnsupportedOperationException e) {
                ParameterDescriptorGroup c = this.getParameterDescriptors();
                formatter.setInvalidWKT((IdentifiedObject)(c != null ? c : this), (Exception)e);
                parameters = null;
            }
            if (parameters != null) {
                boolean filter = isGeogTran || WKTUtilities.isEPSG((GeneralParameterDescriptor)parameters.getDescriptor(), false) && "EPSG".equalsIgnoreCase(Citations.toCodeSpace((Citation)formatter.getNameAuthority()));
                formatter.newLine();
                formatter.indent(1);
                for (GeneralParameterValue param : parameters.values()) {
                    if (filter && !WKTUtilities.isEPSG(param.getDescriptor(), true)) continue;
                    WKTUtilities.append(param, formatter);
                }
                formatter.indent(-1);
            }
        }
        if (!(isSubOperation || isGeogTran || this instanceof ConcatenatedOperation)) {
            AbstractCoordinateOperation.append(formatter, this.getInterpolationCRS(), "InterpolationCRS");
            final double accuracy = this.getLinearAccuracy();
            if (accuracy > 0.0) {
                formatter.append(new FormattableObject(){

                    @Override
                    protected String formatTo(Formatter formatter) {
                        formatter.append(accuracy);
                        return "OperationAccuracy";
                    }
                });
            }
        }
        if (isGeogTran) {
            if (method == null || convention != Convention.WKT1_IGNORE_AXES) {
                formatter.setInvalidWKT(this, null);
            }
            return "GeogTran";
        }
        if (isWKT1) {
            formatter.setInvalidWKT(this, null);
        }
        if (isComponent) {
            formatter.setInvalidWKT(this, null);
            return "CoordinateOperationStep";
        }
        return "CoordinateOperation";
    }

    private static void append(Formatter formatter, final CoordinateReferenceSystem crs, final String type) {
        if (crs != null) {
            formatter.append(new FormattableObject(){

                @Override
                protected String formatTo(Formatter formatter) {
                    formatter.indent(-1);
                    formatter.append(WKTUtilities.toFormattable(crs));
                    formatter.indent(1);
                    return type;
                }
            });
            formatter.newLine();
        }
    }

    AbstractCoordinateOperation() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    @XmlElement(name="sourceCRS")
    private CoordinateReferenceSystem getSource() {
        return this.isDefiningConversion() ? null : this.getSourceCRS();
    }

    private void setSource(CoordinateReferenceSystem crs) {
        if (this.sourceCRS == null) {
            this.sourceCRS = crs;
        } else if (!this.sourceCRS.equals(crs)) {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, (String)"setSource", (String)"sourceCRS");
        }
    }

    @XmlElement(name="targetCRS")
    private CoordinateReferenceSystem getTarget() {
        return this.isDefiningConversion() ? null : this.getTargetCRS();
    }

    private void setTarget(CoordinateReferenceSystem crs) {
        if (this.targetCRS == null) {
            this.targetCRS = crs;
        } else if (!this.targetCRS.equals(crs)) {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, (String)"setTarget", (String)"targetCRS");
        }
    }

    @XmlElement(name="coordinateOperationAccuracy")
    private PositionalAccuracy[] getAccuracy() {
        Collection<PositionalAccuracy> accuracy = this.getCoordinateOperationAccuracy();
        int size = accuracy.size();
        return size != 0 ? accuracy.toArray(new PositionalAccuracy[size]) : null;
    }

    private void setAccuracy(PositionalAccuracy[] values) {
        if (this.coordinateOperationAccuracy == null) {
            this.coordinateOperationAccuracy = UnmodifiableArrayList.wrap((Object[])values);
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, (String)"setAccuracy", (String)"coordinateOperationAccuracy");
        }
    }

    private void setOperationVersion(String value) {
        if (this.operationVersion == null) {
            this.operationVersion = value;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractCoordinateOperation.class, (String)"setOperationVersion", (String)"operationVersion");
        }
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        this.computeTransientFields();
    }
}

