/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.EPSGParameterDomain;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceIdentifier;

final class Verifier {
    private final short errorKey;
    private final boolean internal;
    private final boolean needsValue;
    private final Object[] arguments;

    private Verifier(boolean internal, short errorKey, boolean needsValue, Object ... arguments) {
        this.errorKey = errorKey;
        this.internal = internal;
        this.needsValue = needsValue;
        this.arguments = arguments;
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> descriptor, Object value, Unit<?> unit) throws InvalidParameterValueException {
        Class expectedClass = descriptor.getValueClass();
        UnitConverter converter = null;
        Object convertedValue = value;
        if (unit != null) {
            Unit<?> def = descriptor.getUnit();
            if (def == null && (def = Verifier.getCompatibleUnit(Parameters.getValueDomain(descriptor), unit)) == null) {
                String name = Verifier.getDisplayName(descriptor);
                throw new InvalidParameterValueException(Resources.format((short)65, name), name, unit);
            }
            if (!unit.equals((Object)def)) {
                short expectedID = Verifier.getUnitMessageID(def);
                if (Verifier.getUnitMessageID(unit) != expectedID) {
                    throw new IllegalArgumentException(Errors.format((short)expectedID, unit));
                }
                if (value != null) {
                    if (!expectedClass.isInstance(value)) {
                        String name = Verifier.getDisplayName(descriptor);
                        throw new InvalidParameterValueException(Resources.format((short)24, name, expectedClass, value.getClass()), name, value);
                    }
                    try {
                        converter = unit.getConverterToAny(def);
                    }
                    catch (IncommensurableException e) {
                        throw new IllegalArgumentException(Errors.format((short)66, unit, def), e);
                    }
                    Class<?> componentType = expectedClass.getComponentType();
                    if (componentType != null) {
                        int length = Array.getLength(value);
                        if (length != 0) {
                            Class<Number> numberType = Numbers.primitiveToWrapper(componentType).asSubclass(Number.class);
                            convertedValue = Array.newInstance(componentType, length);
                            int i = 0;
                            try {
                                do {
                                    Number n = (Number)Array.get(value, i);
                                    n = converter.convert(n);
                                    n = Numbers.cast((Number)n, numberType);
                                    Array.set(convertedValue, i, n);
                                } while (++i < length);
                            }
                            catch (IllegalArgumentException e) {
                                throw (InvalidParameterValueException)new InvalidParameterValueException(e.getLocalizedMessage(), Strings.toIndexed((String)Verifier.getDisplayName(descriptor), (int)i), value).initCause((Throwable)e);
                            }
                        }
                    } else {
                        try {
                            Number n = converter.convert((Number)value);
                            convertedValue = Numbers.cast((Number)n, expectedClass.asSubclass(Number.class));
                        }
                        catch (ClassCastException | IllegalArgumentException e) {
                            throw (InvalidParameterValueException)new InvalidParameterValueException(e.getLocalizedMessage(), Verifier.getDisplayName(descriptor), value).initCause((Throwable)e);
                        }
                    }
                }
            }
        }
        if (convertedValue != null) {
            Set validValues = descriptor.getValidValues();
            Verifier error = descriptor instanceof DefaultParameterDescriptor ? Verifier.ensureValidValue(expectedClass, validValues, ((DefaultParameterDescriptor)descriptor).getValueDomain(), convertedValue) : Verifier.ensureValidValue(expectedClass, validValues, descriptor.getMinimumValue(), descriptor.getMaximumValue(), convertedValue);
            if (error != null) {
                error.convertRange(converter);
                String name = Verifier.getDisplayName(descriptor);
                String message = error.message(null, name, value);
                if (!Semaphores.query((int)16)) {
                    throw new InvalidParameterValueException(message, name, value);
                }
                Logging.completeAndLog((Logger)DefaultParameterValue.LOGGER, DefaultParameterValue.class, (String)"setValue", (LogRecord)new LogRecord(Level.WARNING, message));
            }
        }
        return expectedClass.cast(convertedValue);
    }

    static <T> Verifier ensureValidValue(Class<T> valueClass, Set<T> validValues, Range<?> valueDomain, Object convertedValue) {
        Verifier verifier = Verifier.ensureValidValue(valueClass, validValues, null, null, convertedValue);
        if (verifier == null && valueDomain != null) {
            boolean isArray = valueClass.isArray();
            assert (valueDomain.getElementType() == (isArray ? Numbers.primitiveToWrapper(valueClass.getComponentType()) : valueClass)) : valueDomain;
            int length = isArray ? Array.getLength(convertedValue) : 1;
            for (int i = 0; i < length; ++i) {
                Object[] arguments;
                short errorKey;
                Object value;
                Object object = value = isArray ? Array.get(convertedValue, i) : convertedValue;
                if (valueDomain.contains((Comparable)value)) continue;
                Comparable minValue = valueDomain.getMinValue();
                if (minValue instanceof Number && ((Number)((Object)minValue)).doubleValue() == 0.0 && !valueDomain.isMinIncluded() && value instanceof Number && ((Number)value).doubleValue() < 0.0) {
                    errorKey = 165;
                    arguments = new Object[2];
                } else {
                    errorKey = 166;
                    arguments = new Object[4];
                    arguments[1] = minValue;
                    arguments[2] = valueDomain.getMaxValue();
                }
                if (isArray) {
                    arguments[0] = i;
                }
                arguments[arguments.length - 1] = value;
                return new Verifier(false, errorKey, true, arguments);
            }
        }
        return verifier;
    }

    private static <T> Verifier ensureValidValue(Class<T> valueClass, Set<T> validValues, Comparable<T> minimum, Comparable<T> maximum, Object convertedValue) {
        if (!valueClass.isInstance(convertedValue)) {
            return new Verifier(true, 24, false, null, valueClass, convertedValue.getClass());
        }
        if (validValues != null && !validValues.contains(convertedValue)) {
            return new Verifier(true, 25, true, null, convertedValue);
        }
        if (minimum != null && minimum.compareTo(convertedValue) > 0 || maximum != null && maximum.compareTo(convertedValue) < 0) {
            return new Verifier(false, 166, true, null, minimum, maximum, convertedValue);
        }
        return null;
    }

    private void convertRange(UnitConverter converter) {
        if (converter != null && !this.internal && this.errorKey == 166) {
            converter = converter.inverse();
            Object minimumValue = this.arguments[1];
            Object maximumValue = this.arguments[2];
            minimumValue = minimumValue != null ? Double.valueOf(converter.convert(((Number)minimumValue).doubleValue())) : "\u2212\u221e";
            maximumValue = maximumValue != null ? Double.valueOf(converter.convert(((Number)maximumValue).doubleValue())) : "\u221e";
            this.arguments[1] = minimumValue;
            this.arguments[2] = maximumValue;
        }
    }

    private static Unit<?> getCompatibleUnit(Range<?> valueDomain, Unit<?> unit) {
        if (valueDomain instanceof EPSGParameterDomain) {
            for (Unit<?> valid : ((EPSGParameterDomain)valueDomain).units) {
                if (!unit.isCompatible(valid)) continue;
                return valid;
            }
        }
        return null;
    }

    String message(Map<?, ?> properties, String name, Object value) {
        Object index = this.arguments[0];
        if (index != null) {
            name = Strings.bracket((String)name, (Object)index);
            value = Array.get(value, (Integer)index);
        }
        this.arguments[0] = name;
        if (this.needsValue) {
            this.arguments[this.arguments.length - 1] = value;
        }
        return (this.internal ? Resources.forProperties(properties) : Errors.getResources(properties)).getString(this.errorKey, this.arguments);
    }

    static String getDisplayName(GeneralParameterDescriptor descriptor) {
        String code;
        ReferenceIdentifier name;
        if (descriptor != null && (name = descriptor.getName()) != null && (code = name.getCode()) != null) {
            return code;
        }
        return Vocabulary.format((short)208);
    }

    static short getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 103;
        }
        if (Units.isAngular(unit)) {
            return 100;
        }
        if (Units.isTemporal(unit)) {
            return 107;
        }
        if (Units.isScale(unit)) {
            return 105;
        }
        return 65;
    }
}

