/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.apache.baremaps.shapefile.ShapefileDataTable;
import org.apache.baremaps.store.DataStore;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;

public class ShapefileDataStore
implements DataStore {
    private final Path directory;

    public ShapefileDataStore(Path directory) {
        this.directory = directory;
    }

    public List<String> list() {
        List<String> list;
        block8: {
            Stream<Path> files = Files.list(this.directory);
            try {
                list = files.filter(file -> file.toString().toLowerCase().endsWith(".shp")).map(file -> file.getFileName().toString()).toList();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DataStoreException((Throwable)e);
                }
            }
            files.close();
        }
        return list;
    }

    public DataTable get(String name) {
        return new ShapefileDataTable(this.directory.resolve(name));
    }

    public void add(DataTable table) {
        throw new UnsupportedOperationException();
    }

    public void add(String name, DataTable table) throws DataStoreException {
        throw new UnsupportedOperationException();
    }

    public void remove(String name) {
        throw new UnsupportedOperationException();
    }
}

