/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.simple;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.PropertyEnvironment;

public class SimpleLoggerConfiguration {
    protected final PropertyEnvironment environment;

    public SimpleLoggerConfiguration(PropertyEnvironment environment) {
        this.environment = environment;
    }

    public boolean isContextMapShown() {
        return this.environment.getBooleanProperty("org.apache.logging.log4j.simplelog.showContextMap", false);
    }

    public boolean isLogNameShown() {
        return this.environment.getBooleanProperty("org.apache.logging.log4j.simplelog.showlogname", false);
    }

    public boolean isShortNameShown() {
        return this.environment.getBooleanProperty("org.apache.logging.log4j.simplelog.showShortLogname", true);
    }

    public boolean isDateTimeShown() {
        return this.environment.getBooleanProperty("org.apache.logging.log4j.simplelog.showdatetime", false);
    }

    public Level getDefaultLevel() {
        String level = this.environment.getStringProperty("org.apache.logging.log4j.simplelog.level");
        return Level.toLevel(level, Level.ERROR);
    }

    public Level getLoggerLevel(String loggerName) {
        String level = this.environment.getStringProperty("org.apache.logging.log4j.simplelog." + loggerName + ".level");
        return Level.toLevel(level, this.getDefaultLevel());
    }

    public DateFormat getDateTimeFormat() {
        try {
            return new SimpleDateFormat(this.environment.getStringProperty("org.apache.logging.log4j.simplelog.dateTimeFormat", "yyyy/MM/dd HH:mm:ss:SSS zzz"));
        }
        catch (IllegalArgumentException e) {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
        }
    }

    public String getLogFileName() {
        return this.environment.getStringProperty("org.apache.logging.log4j.simplelog.logFile", "system.err");
    }
}

