/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.flatgeobuf;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import org.apache.baremaps.flatgeobuf.FlatGeoBufDataTable;
import org.apache.baremaps.store.DataStore;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;

public class FlatGeoBufDataStore
implements DataStore {
    private final Path directory;

    public FlatGeoBufDataStore(Path directory) {
        this.directory = directory;
    }

    public List<String> list() throws DataStoreException {
        List<String> list;
        block8: {
            Stream<Path> files = Files.list(this.directory);
            try {
                list = files.filter(file -> file.toString().toLowerCase().endsWith(".fgb")).map(file -> file.getFileName().toString()).toList();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DataStoreException((Throwable)e);
                }
            }
            files.close();
        }
        return list;
    }

    public DataTable get(String name) throws DataStoreException {
        Path path = this.directory.resolve(name);
        return new FlatGeoBufDataTable(path);
    }

    public void add(DataTable table) throws DataStoreException {
        Object fileName = table.schema().name();
        fileName = ((String)fileName).endsWith(".fgb") ? fileName : (String)fileName + ".fgb";
        this.add((String)fileName, table);
    }

    public void add(String name, DataTable table) throws DataStoreException {
        Path path = this.directory.resolve(name);
        try {
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
            FlatGeoBufDataTable flatGeoBufTable = new FlatGeoBufDataTable(path, table.schema());
            flatGeoBufTable.write(table);
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    public void remove(String name) throws DataStoreException {
        Path path = this.directory.resolve(name);
        if (name.equals(path.getFileName().toString())) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new DataStoreException((Throwable)e);
            }
        } else {
            throw new DataStoreException("Table not found");
        }
    }
}

