/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
final class DirectoryHelperUtils {
    private DirectoryHelperUtils() {
    }

    static String normalizeKey(String prefix, String key, String delimiter) {
        Validate.notNull((Object)delimiter, (String)"delimiter must not be null", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)prefix)) {
            return key;
        }
        if (!key.startsWith(prefix)) {
            return key;
        }
        if (!key.contains(delimiter)) {
            return key;
        }
        String stripped = key.substring(prefix.length());
        if (prefix.endsWith(delimiter) || !stripped.startsWith(delimiter)) {
            return stripped;
        }
        return stripped.substring(1);
    }
}

