/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.GroupByTransform;

final class GroupBySample
extends Group<GroupByCRS<GroupByTransform>> {
    private final List<SampleDimension> ranges;

    private GroupBySample(List<SampleDimension> ranges) {
        this.ranges = List.copyOf(ranges);
    }

    @Override
    final String createName(Locale locale) {
        StringJoiner name = new StringJoiner(", ");
        for (SampleDimension range : this.ranges) {
            name.add(range.getName().toInternationalString().toString(locale));
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GroupBySample getOrAdd(List<GroupBySample> groups, List<SampleDimension> ranges) {
        List<GroupBySample> list = groups;
        synchronized (list) {
            for (GroupBySample c : groups) {
                if (!ranges.equals(c.ranges)) continue;
                return c;
            }
            GroupBySample c = new GroupBySample(ranges);
            groups.add(c);
            return c;
        }
    }

    final void createComponents(GroupAggregate destination) {
        destination.sampleDimensions = this.ranges;
        destination.fillWithChildAggregates(this, (byCRS, child) -> {
            child.fillWithCoverageComponents(byCRS.members, this.ranges);
            child.sampleDimensions = this.ranges;
        });
    }
}

