/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.property;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoPackageProperties {
    private static final Logger log = Logger.getLogger(GeoPackageProperties.class.getName());
    private static Properties mProperties;

    public static String getProperty(String key) {
        return GeoPackageProperties.getProperty(key, true);
    }

    public static synchronized String getProperty(String key, boolean required) {
        String value;
        if (mProperties == null) {
            mProperties = GeoPackageProperties.initializeConfigurationProperties();
        }
        if ((value = mProperties.getProperty(key)) == null && required) {
            throw new RuntimeException("Property not found: " + key);
        }
        return value;
    }

    public static String getProperty(String ... properties) {
        return GeoPackageProperties.getProperty(true, properties);
    }

    public static String getProperty(boolean required, String ... properties) {
        return GeoPackageProperties.getProperty(GeoPackageProperties.buildProperty(properties), required);
    }

    public static int getIntegerProperty(String key) {
        return GeoPackageProperties.getIntegerProperty(key, true);
    }

    public static Integer getIntegerProperty(String key, boolean required) {
        Integer value = null;
        String stringValue = GeoPackageProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Integer.valueOf(stringValue);
        }
        return value;
    }

    public static int getIntegerProperty(String ... properties) {
        return GeoPackageProperties.getIntegerProperty(true, properties);
    }

    public static Integer getIntegerProperty(boolean required, String ... properties) {
        return GeoPackageProperties.getIntegerProperty(GeoPackageProperties.buildProperty(properties), required);
    }

    public static float getFloatProperty(String key) {
        return GeoPackageProperties.getFloatProperty(key, true).floatValue();
    }

    public static Float getFloatProperty(String key, boolean required) {
        Float value = null;
        String stringValue = GeoPackageProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Float.valueOf(stringValue);
        }
        return value;
    }

    public static float getFloatProperty(String ... properties) {
        return GeoPackageProperties.getFloatProperty(true, properties).floatValue();
    }

    public static Float getFloatProperty(boolean required, String ... properties) {
        return GeoPackageProperties.getFloatProperty(GeoPackageProperties.buildProperty(properties), required);
    }

    public static boolean getBooleanProperty(String key) {
        return GeoPackageProperties.getBooleanProperty(key, true);
    }

    public static Boolean getBooleanProperty(String key, boolean required) {
        Boolean value = null;
        String stringValue = GeoPackageProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Boolean.valueOf(stringValue);
        }
        return value;
    }

    public static boolean getBooleanProperty(String ... properties) {
        return GeoPackageProperties.getBooleanProperty(true, properties);
    }

    public static Boolean getBooleanProperty(boolean required, String ... properties) {
        return GeoPackageProperties.getBooleanProperty(GeoPackageProperties.buildProperty(properties), required);
    }

    private static Properties initializeConfigurationProperties() {
        Properties properties = new Properties();
        InputStream in = GeoPackageProperties.class.getResourceAsStream("/geopackage.properties");
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load properties file: geopackage.properties", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to close properties file: geopackage.properties", e);
                }
            }
        } else {
            log.log(Level.SEVERE, "Failed to load properties, file not found: geopackage.properties");
        }
        return properties;
    }

    public static String buildProperty(String ... properties) {
        StringBuilder combined = new StringBuilder();
        for (String property : properties) {
            if (property == null) continue;
            if (combined.length() > 0) {
                combined.append(".");
            }
            combined.append(property);
        }
        return combined.toString();
    }
}

