/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.geometric;

import com.xugu.geometric.DBpoint;
import com.xugu.util.DBobject;
import com.xugu.util.DBtokenizer;
import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DBpolygon
extends DBobject
implements Serializable,
Cloneable {
    public DBpoint @Nullable [] points;

    public DBpolygon(DBpoint[] points) {
        this();
        this.points = points;
    }

    public DBpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public DBpolygon() {
        this.type = "polygon";
    }

    @Override
    public void setValue(@Nullable String s) throws SQLException {
        if (s == null) {
            this.points = null;
            return;
        }
        DBtokenizer t = new DBtokenizer(DBtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        DBpoint[] points = this.points;
        if (points == null || points.length != npoints) {
            this.points = points = new DBpoint[npoints];
        }
        for (int p = 0; p < npoints; ++p) {
            points[p] = new DBpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof DBpolygon) {
            DBpolygon p = (DBpolygon)obj;
            DBpoint[] points = this.points;
            DBpoint[] pPoints = p.points;
            if (points == null) {
                return pPoints == null;
            }
            if (pPoints == null) {
                return false;
            }
            if (pPoints.length != points.length) {
                return false;
            }
            for (int i = 0; i < points.length; ++i) {
                if (points[i].equals(pPoints[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        DBpoint[] points = this.points;
        if (points == null) {
            return hash;
        }
        for (int i = 0; i < points.length && i < 5; ++i) {
            hash = hash * 31 + points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DBpolygon newDBpolygon = (DBpolygon)super.clone();
        if (newDBpolygon.points != null) {
            DBpoint[] newPoints = (DBpoint[])newDBpolygon.points.clone();
            newDBpolygon.points = newPoints;
            for (int i = 0; i < newDBpolygon.points.length; ++i) {
                if (newDBpolygon.points[i] == null) continue;
                newPoints[i] = (DBpoint)newDBpolygon.points[i].clone();
            }
        }
        return newDBpolygon;
    }

    @Override
    public @Nullable String getValue() {
        DBpoint[] points = this.points;
        if (points == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (int p = 0; p < points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(points[p].toString());
        }
        b.append(")");
        return b.toString();
    }
}

