---
title: "How to use CORS"
slug: /security/how-to-use-cors
keyword: security cors
license: "This software is licensed under the Apache License version 2."
---

## Cross-origin resource filter

### Server configuration

| Configuration item                                 | Description                                                                                                                                                                                                                            | Default value                                 | Required | Since version |
|----------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------|----------|---------------|
| `gravitino.server.webserver.enableCorsFilter`      | Enable cross-origin resource share filter.                                                                                                                                                                                             | false                                         | No       | 0.4.0         |
| `gravitino.server.webserver.allowedOrigins`        | A comma separated list of allowed origins to access the resources. The default value is *, which means all origins.                                                                                                                    | `*`                                           | No       | 0.4.0         |
| `gravitino.server.webserver.allowedTimingOrigins`  | A comma separated list of allowed origins to time the resource. The default value is the empty string, which means no origins.                                                                                                         | ''(empty string)                              | No       | 0.4.0         |
| `gravitino.server.webserver.allowedMethods`        | A comma separated list of allowed HTTP methods used when accessing the resources. The default values are GET, POST, HEAD, and DELETE.                                                                                                  | `GET,POST,HEAD,DELETE,PUT`                    | No       | 0.4.0         |
| `gravitino.server.webserver.allowedHeaders`        | A comma separated list of allowed HTTP headers specified when accessing the resources. The default value is X-Requested-With,Content-Type,Accept,Origin. If the value is a single *, it accepts all headers.                           | `X-Requested-With,Content-Type,Accept,Origin` | No       | 0.4.0         |
| `gravitino.server.webserver.preflightMaxAgeInSecs` | The number of seconds to cache preflight requests by the client. The default value is 1800 seconds or 30 minutes.                                                                                                                      | `1800`                                        | No       | 0.4.0         |
| `gravitino.server.webserver.allowCredentials`      | A boolean indicating if the resource allows requests with credentials. The default value is true.                                                                                                                                      | `true`                                        | No       | 0.4.0         |
| `gravitino.server.webserver.exposedHeaders`        | A comma separated list of allowed HTTP headers exposed on the client. The default value is the empty list.                                                                                                                             | ''(empty string)                              | No       | 0.4.0         |
| `gravitino.server.webserver.chainPreflight`        | If true chained preflight requests for normal handling (as an OPTION request). Otherwise, the filter responds to the preflight. The default is true.                                                                                   | `true`                                        | No       | 0.4.0         |

### Apache Iceberg REST service's configuration

| Configuration item                             | Description                                                                                                                                                                                                  | Default value                                 | Required | Since version |
|------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------|----------|---------------|
| `gravitino.iceberg-rest.enableCorsFilter`      | Enable cross-origin resource share filter.                                                                                                                                                                   | false                                         | No       | 0.4.0         |
| `gravitino.iceberg-rest.allowedOrigins`        | A comma separated list of allowed origins that access the resources. The default value is *, which means all origins.                                                                                        | `*`                                           | No       | 0.4.0         |
| `gravitino.iceberg-rest.allowedTimingOrigins`  | A comma separated list of allowed origins that time the resource. The default value is the empty string, which means no origins.                                                                             | ''(empty string)                              | No       | 0.4.0         |
| `gravitino.iceberg-rest.allowedMethods`        | A comma separated list of allowed HTTP methods used when accessing the resources. The default values are GET, POST, HEAD, and DELETE.                                                                        | `GET,POST,HEAD,DELETE,PUT`                    | No       | 0.4.0         |
| `gravitino.iceberg-rest.allowedHeaders`        | A comma separated list of HTTP allowed headers specified when accessing the resources. The default value is X-Requested-With,Content-Type,Accept,Origin. If the value is a single *, it accepts all headers. | `X-Requested-With,Content-Type,Accept,Origin` | No       | 0.4.0         |
| `gravitino.iceberg-rest.preflightMaxAgeInSecs` | The number of seconds to cache preflight requests by the client. The default value is 1800 seconds or 30 minutes.                                                                                            | `1800`                                        | No       | 0.4.0         |
| `gravitino.iceberg-rest.allowCredentials`      | A boolean indicating if the resource allows requests with credentials. The default value is true.                                                                                                            | `true`                                        | No       | 0.4.0         |
| `gravitino.iceberg-rest.exposedHeaders`        | A comma separated list of allowed HTTP headers exposed on the client. The default value is the empty list.                                                                                                   | ''(empty string)                              | No       | 0.4.0         |
| `gravitino.iceberg-rest.chainPreflight`        | If true chained preflight requests for normal handling (as an OPTION request). Otherwise, the filter responds to the preflight. The default is true.                                                         | `true`                                        | No       | 0.4.0         |
