/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.context;

import com.siemens.ct.exi.core.grammars.event.Attribute;
import com.siemens.ct.exi.core.grammars.event.StartElement;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import javax.xml.namespace.QName;

public class QNameContext {
    final int namespaceUriID;
    final int localNameID;
    final QName qName;
    final String defaultQNameAsString;
    final String defaultPrefix;
    StartElement grammarGlobalElement;
    Attribute grammarGlobalAttribute;
    SchemaInformedFirstStartTagGrammar typeGrammar;

    public QNameContext(int namespaceUriID, int localNameID, QName qName) {
        this.namespaceUriID = namespaceUriID;
        this.localNameID = localNameID;
        this.qName = qName;
        switch (namespaceUriID) {
            case 0: {
                this.defaultPrefix = "";
                this.defaultQNameAsString = this.qName.getLocalPart();
                break;
            }
            case 1: {
                this.defaultPrefix = "xml";
                this.defaultQNameAsString = this.defaultPrefix + ":" + this.qName.getLocalPart();
                break;
            }
            case 2: {
                this.defaultPrefix = "xsi";
                this.defaultQNameAsString = this.defaultPrefix + ":" + this.qName.getLocalPart();
                break;
            }
            default: {
                this.defaultPrefix = "ns" + namespaceUriID;
                this.defaultQNameAsString = this.defaultPrefix + ":" + this.qName.getLocalPart();
            }
        }
    }

    public QName getQName() {
        return this.qName;
    }

    public String getDefaultQNameAsString() {
        return this.defaultQNameAsString;
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public int getLocalNameID() {
        return this.localNameID;
    }

    public String getLocalName() {
        return this.qName.getLocalPart();
    }

    public void setGlobalStartElement(StartElement grammarGlobalElement) {
        this.grammarGlobalElement = grammarGlobalElement;
    }

    public StartElement getGlobalStartElement() {
        return this.grammarGlobalElement;
    }

    public void setGlobalAttribute(Attribute grammarGlobalAttribute) {
        this.grammarGlobalAttribute = grammarGlobalAttribute;
    }

    public Attribute getGlobalAttribute() {
        return this.grammarGlobalAttribute;
    }

    public void setTypeGrammar(SchemaInformedFirstStartTagGrammar typeGrammar) {
        this.typeGrammar = typeGrammar;
    }

    public SchemaInformedFirstStartTagGrammar getTypeGrammar() {
        return this.typeGrammar;
    }

    public int getNamespaceUriID() {
        return this.namespaceUriID;
    }

    public String getNamespaceUri() {
        return this.qName.getNamespaceURI();
    }

    protected int compareTo(String localName) {
        return this.getQName().getLocalPart().compareTo(localName);
    }

    public String toString() {
        return "{" + this.namespaceUriID + "}" + this.localNameID + "," + this.getLocalName();
    }

    public final boolean equals(Object o) {
        if (o instanceof QNameContext) {
            QNameContext other = (QNameContext)o;
            return other.localNameID == this.localNameID && other.namespaceUriID == this.namespaceUriID;
        }
        return false;
    }

    public final int hashCode() {
        return this.namespaceUriID ^ this.localNameID;
    }
}

