/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.ArrayList;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.AttributeStatementProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.secext.UsernameTokenType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.w3c.dom.Element;

public class ActAsAttributeStatementProvider
implements AttributeStatementProvider {
    @Override
    public AttributeStatementBean getStatement(TokenProviderParameters providerParameters) {
        AttributeStatementBean attrBean = new AttributeStatementBean();
        TokenRequirements tokenRequirements = providerParameters.getTokenRequirements();
        ReceivedToken actAs = tokenRequirements.getActAs();
        try {
            if (actAs != null) {
                ArrayList<AttributeBean> attributeList = new ArrayList<AttributeBean>();
                String tokenType = tokenRequirements.getTokenType();
                AttributeBean parameterBean = this.handleAdditionalParameters(actAs.getToken(), tokenType);
                if (!parameterBean.getAttributeValues().isEmpty()) {
                    attributeList.add(parameterBean);
                }
                attrBean.setSamlAttributes(attributeList);
            }
        }
        catch (WSSecurityException ex) {
            throw new STSException(ex.getMessage(), (Throwable)ex);
        }
        return attrBean;
    }

    private AttributeBean handleAdditionalParameters(Object parameter, String tokenType) throws WSSecurityException {
        AttributeBean parameterBean;
        block9: {
            SamlAssertionWrapper wrapper;
            block10: {
                block8: {
                    parameterBean = new AttributeBean();
                    String claimType = "ActAs";
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
                        parameterBean.setSimpleName(claimType);
                        parameterBean.setQualifiedName("http://cxf.apache.org/sts");
                    } else {
                        parameterBean.setQualifiedName(claimType);
                        parameterBean.setNameFormat("http://cxf.apache.org/sts");
                    }
                    if (!(parameter instanceof UsernameTokenType)) break block8;
                    parameterBean.addAttributeValue((Object)((UsernameTokenType)parameter).getUsername().getValue());
                    break block9;
                }
                if (!(parameter instanceof Element)) break block9;
                wrapper = new SamlAssertionWrapper((Element)parameter);
                SAMLTokenPrincipalImpl principal = new SAMLTokenPrincipalImpl(wrapper);
                parameterBean.addAttributeValue((Object)principal.getName());
                if (wrapper.getSaml2() == null) break block10;
                for (org.opensaml.saml.saml2.core.AttributeStatement attributeStatement : wrapper.getSaml2().getAttributeStatements()) {
                    for (org.opensaml.saml.saml2.core.Attribute attribute : attributeStatement.getAttributes()) {
                        if (!"ActAs".equals(attribute.getName())) continue;
                        for (XMLObject attributeValue : attribute.getAttributeValues()) {
                            Element attributeValueElement = attributeValue.getDOM();
                            String text = attributeValueElement.getTextContent();
                            parameterBean.addAttributeValue((Object)text);
                        }
                    }
                }
                break block9;
            }
            if (wrapper.getSaml1() == null) break block9;
            for (AttributeStatement attributeStatement : wrapper.getSaml1().getAttributeStatements()) {
                for (Attribute attribute : attributeStatement.getAttributes()) {
                    if (!"ActAs".equals(attribute.getAttributeName())) continue;
                    for (XMLObject attributeValue : attribute.getAttributeValues()) {
                        Element attributeValueElement = attributeValue.getDOM();
                        String text = attributeValueElement.getTextContent();
                        parameterBean.addAttributeValue((Object)text);
                    }
                }
            }
        }
        return parameterBean;
    }
}

