/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import io.netty.handler.ssl.SslContext;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.spi.core.remoting.ssl.OpenSSLContextFactory;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenSSLContextFactory
implements OpenSSLContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public SslContext getClientSslContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        logger.debug("Creating Client OpenSSL Context with {}", (Object)config);
        return new SSLSupport(config).setSslProvider("OPENSSL").createNettyClientContext();
    }

    @Override
    public SslContext getServerSslContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        logger.debug("Creating Server OpenSSL Context with {}", (Object)config);
        return new SSLSupport(config).setSslProvider("OPENSSL").createNettyContext();
    }

    @Override
    public int getPriority() {
        return 5;
    }
}

