/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso.state;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.saml.sso.state.RequestState;
import org.apache.cxf.rs.security.saml.sso.state.ResponseState;
import org.apache.cxf.rs.security.saml.sso.state.SPStateManager;
import org.apache.wss4j.common.util.Loader;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.Status;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHCacheSPStateManager
implements SPStateManager {
    public static final String REQUEST_CACHE_KEY = "cxf.samlp.request.state.cache";
    public static final String RESPONSE_CACHE_KEY = "cxf.samlp.response.state.cache";
    private static final String DEFAULT_CONFIG_URL = "/cxf-samlp-ehcache.xml";
    private static final Logger LOG = LoggerFactory.getLogger(EHCacheSPStateManager.class);
    private final Cache<String, RequestState> requestCache;
    private final Cache<String, ResponseState> responseCache;
    private final CacheManager requestCacheManager;
    private final CacheManager responseCacheManager;

    public EHCacheSPStateManager() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this(DEFAULT_CONFIG_URL, null);
    }

    public EHCacheSPStateManager(Bus bus) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this(DEFAULT_CONFIG_URL, bus);
    }

    public EHCacheSPStateManager(String configFileURL) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this(configFileURL, null);
    }

    public EHCacheSPStateManager(String configFile, Bus bus) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ResourceUtils.getClasspathResourceURL((String)configFile, EHCacheSPStateManager.class, (Bus)bus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        XmlConfiguration xmlConfig = new XmlConfiguration(this.getConfigFileURL(configFileURL));
        CacheConfigurationBuilder requestConfigurationBuilder = xmlConfig.newCacheConfigurationBuilderFromTemplate(REQUEST_CACHE_KEY, String.class, RequestState.class);
        String diskKey = "cxf.samlp.request.state.cache-" + Math.abs(new Random().nextInt());
        this.requestCacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(REQUEST_CACHE_KEY, (Builder)requestConfigurationBuilder).with(CacheManagerBuilder.persistence((File)new File(System.getProperty("java.io.tmpdir"), diskKey))).build();
        this.requestCacheManager.init();
        this.requestCache = this.requestCacheManager.getCache(REQUEST_CACHE_KEY, String.class, RequestState.class);
        CacheConfigurationBuilder responseConfigurationBuilder = xmlConfig.newCacheConfigurationBuilderFromTemplate(RESPONSE_CACHE_KEY, String.class, ResponseState.class);
        diskKey = "cxf.samlp.response.state.cache-" + Math.abs(new Random().nextInt());
        this.responseCacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(RESPONSE_CACHE_KEY, (Builder)responseConfigurationBuilder).with(CacheManagerBuilder.persistence((File)new File(System.getProperty("java.io.tmpdir"), diskKey))).build();
        this.responseCacheManager.init();
        this.responseCache = this.responseCacheManager.getCache(RESPONSE_CACHE_KEY, String.class, ResponseState.class);
    }

    private URL getConfigFileURL(URL suppliedConfigFileURL) {
        if (suppliedConfigFileURL == null) {
            try {
                URL configFileURL = Loader.getResource((String)DEFAULT_CONFIG_URL);
                if (configFileURL == null) {
                    configFileURL = new URL(DEFAULT_CONFIG_URL);
                }
                return configFileURL;
            }
            catch (IOException e) {
                LOG.debug(e.getMessage());
            }
        }
        return suppliedConfigFileURL;
    }

    @Override
    public ResponseState getResponseState(String securityContextKey) {
        return (ResponseState)this.responseCache.get((Object)securityContextKey);
    }

    @Override
    public ResponseState removeResponseState(String securityContextKey) {
        ResponseState responseState = this.getResponseState(securityContextKey);
        if (responseState != null) {
            this.responseCache.remove((Object)securityContextKey);
        }
        return responseState;
    }

    @Override
    public void setResponseState(String securityContextKey, ResponseState state) {
        if (securityContextKey == null || "".equals(securityContextKey)) {
            return;
        }
        this.responseCache.put((Object)securityContextKey, (Object)state);
    }

    @Override
    public void setRequestState(String relayState, RequestState state) {
        if (relayState == null || "".equals(relayState)) {
            return;
        }
        this.requestCache.put((Object)relayState, (Object)state);
    }

    @Override
    public RequestState removeRequestState(String relayState) {
        RequestState state = (RequestState)this.requestCache.get((Object)relayState);
        if (state != null) {
            this.requestCache.remove((Object)relayState);
        }
        return state;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.requestCacheManager.getStatus() == Status.AVAILABLE) {
            this.requestCacheManager.removeCache(REQUEST_CACHE_KEY);
            this.requestCacheManager.close();
        }
        if (this.responseCacheManager.getStatus() == Status.AVAILABLE) {
            this.responseCacheManager.removeCache(RESPONSE_CACHE_KEY);
            this.responseCacheManager.close();
        }
    }
}

