/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.interval;

import org.apache.commons.statistics.distribution.BetaDistribution;
import org.apache.commons.statistics.distribution.NormalDistribution;
import org.apache.commons.statistics.interval.ArgumentUtils;
import org.apache.commons.statistics.interval.BaseInterval;
import org.apache.commons.statistics.interval.Interval;

public enum BinomialConfidenceInterval {
    NORMAL_APPROXIMATION{

        @Override
        Interval create(int n, int x, double alpha) {
            double z = NORMAL_DISTRIBUTION.inverseSurvivalProbability(alpha * 0.5);
            double p = (double)x / (double)n;
            double distance = z * Math.sqrt(p * (1.0 - p) / (double)n);
            return new BaseInterval(1.clip(p - distance), 1.clip(p + distance));
        }
    }
    ,
    WILSON_SCORE{

        @Override
        Interval create(int n, int x, double alpha) {
            double z = NORMAL_DISTRIBUTION.inverseSurvivalProbability(alpha * 0.5);
            double z2 = z * z;
            double p = (double)x / (double)n;
            double denom = 1.0 + z2 / (double)n;
            double centre = (p + 0.5 * z2 / (double)n) / denom;
            double distance = z * Math.sqrt(p * (1.0 - p) / (double)n + z2 / (4.0 * (double)n * (double)n)) / denom;
            return new BaseInterval(centre - distance, centre + distance);
        }
    }
    ,
    JEFFREYS{

        @Override
        Interval create(int n, int x, double alpha) {
            BetaDistribution d = BetaDistribution.of((double)((double)x + 0.5), (double)((double)(n - x) + 0.5));
            double lower = x == 0 ? 0.0 : d.inverseCumulativeProbability(alpha * 0.5);
            double upper = x == n ? 1.0 : d.inverseSurvivalProbability(alpha * 0.5);
            return new BaseInterval(lower, upper);
        }
    }
    ,
    CLOPPER_PEARSON{

        @Override
        Interval create(int n, int x, double alpha) {
            double lower = 0.0;
            double upper = 1.0;
            if (x == 0) {
                upper = 1.0 - Math.pow(alpha * 0.5, 1.0 / (double)n);
            } else if (x == n) {
                lower = Math.pow(alpha * 0.5, 1.0 / (double)n);
            } else {
                lower = BetaDistribution.of((double)x, (double)(n - x + 1)).inverseCumulativeProbability(alpha * 0.5);
                upper = BetaDistribution.of((double)(x + 1), (double)(n - x)).inverseSurvivalProbability(alpha * 0.5);
            }
            return new BaseInterval(lower, upper);
        }
    }
    ,
    AGRESTI_COULL{

        @Override
        Interval create(int n, int x, double alpha) {
            double z = NORMAL_DISTRIBUTION.inverseSurvivalProbability(alpha * 0.5);
            double zSquared = z * z;
            double nc = (double)n + zSquared;
            double p = ((double)x + 0.5 * zSquared) / nc;
            double distance = z * Math.sqrt(p * (1.0 - p) / nc);
            return new BaseInterval(5.clip(p - distance), 5.clip(p + distance));
        }
    };

    static final NormalDistribution NORMAL_DISTRIBUTION;

    public Interval fromErrorRate(int numberOfTrials, int numberOfSuccesses, double alpha) {
        if (numberOfTrials <= 0) {
            throw new IllegalArgumentException("Number of trials is not strictly positive: " + numberOfTrials);
        }
        if (numberOfSuccesses < 0) {
            throw new IllegalArgumentException("Number of successes is not positive: " + numberOfSuccesses);
        }
        if (numberOfSuccesses > numberOfTrials) {
            throw new IllegalArgumentException(String.format("Number of successes (%d) must be less than or equal to number of trials (%d)", numberOfSuccesses, numberOfTrials));
        }
        ArgumentUtils.checkErrorRate(alpha);
        return this.create(numberOfTrials, numberOfSuccesses, alpha);
    }

    abstract Interval create(int var1, int var2, double var3);

    static double clip(double p) {
        return Math.min(1.0, Math.max(0.0, p));
    }

    static {
        NORMAL_DISTRIBUTION = NormalDistribution.of((double)0.0, (double)1.0);
    }
}

