/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathContextFactoryConfigurationError;
import org.apache.commons.jxpath.util.ClassLoaderUtil;

public abstract class JXPathContextFactory {
    public static final String FACTORY_NAME_PROPERTY = "org.apache.commons.jxpath.JXPathContextFactory";
    private static final String DEFAULT_FACTORY_CLASS = "org.apache.commons.jxpath.ri.JXPathContextFactoryReferenceImpl";
    private static final String FACTORY_IMPL_NAME = JXPathContextFactory.findFactory("org.apache.commons.jxpath.JXPathContextFactory", "org.apache.commons.jxpath.ri.JXPathContextFactoryReferenceImpl");
    private static boolean debug;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findFactory(String property, String defaultFactory) {
        block22: {
            try {
                String systemProp = System.getProperty(property);
                if (systemProp != null) {
                    if (!debug) return systemProp;
                    System.err.println("JXPath: found system property" + systemProp);
                    return systemProp;
                }
            }
            catch (SecurityException systemProp) {
                // empty catch block
            }
            try {
                Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
                Path configFile = javaHome.resolve(Paths.get("lib", "jxpath.properties"));
                if (!Files.exists(configFile, new LinkOption[0])) break block22;
                Properties props = new Properties();
                try (InputStream fis = Files.newInputStream(configFile, new OpenOption[0]);){
                    props.load(fis);
                }
                String factory2 = props.getProperty(property);
                if (factory2 != null) {
                    if (!debug) return factory2;
                    System.err.println("JXPath: found java.home property " + factory2);
                    return factory2;
                }
            }
            catch (IOException ex) {
                if (!debug) break block22;
                ex.printStackTrace();
            }
        }
        String serviceId = "META-INF/services/" + property;
        try {
            ClassLoader cl = JXPathContextFactory.class.getClassLoader();
            try (InputStream is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);){
                BufferedReader rd;
                String factory;
                if (is == null) return defaultFactory;
                if (debug) {
                    System.err.println("JXPath: found  " + serviceId);
                }
                if ((factory = (rd = new BufferedReader(new InputStreamReader(is, "UTF-8"))).readLine()) == null) return defaultFactory;
                if ("".equals(factory)) return defaultFactory;
                if (debug) {
                    System.err.println("JXPath: loaded from services: " + factory);
                }
                String string = factory;
                return string;
            }
        }
        catch (Exception ex) {
            if (!debug) return defaultFactory;
            ex.printStackTrace();
        }
        return defaultFactory;
    }

    public static JXPathContextFactory newInstance() {
        JXPathContextFactory factoryImpl;
        try {
            factoryImpl = (JXPathContextFactory)ClassLoaderUtil.getClass(FACTORY_IMPL_NAME, true).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ie) {
            throw new JXPathContextFactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    protected JXPathContextFactory() {
    }

    public abstract JXPathContext newContext(JXPathContext var1, Object var2);

    static {
        try {
            debug = System.getProperty("jxpath.debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

