/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base32OutputStream;
import org.apache.commons.codec.binary.Base32Test;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNTestData;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Base32OutputStreamTest {
    private static final byte[] CR_LF = new byte[]{13, 10};
    private static final byte[] LF = new byte[]{10};

    Base32OutputStreamTest() {
    }

    private void testBase32EmptyOutputStream(int chunkSize) throws Exception {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded, chunkSize, CR_LF);
        this.testByChunk(emptyEncoded, emptyDecoded, chunkSize, CR_LF);
    }

    @Test
    void testBase32EmptyOutputStreamMimeChunkSize() throws Exception {
        this.testBase32EmptyOutputStream(76);
    }

    @Test
    void testBase32EmptyOutputStreamPemChunkSize() throws Exception {
        this.testBase32EmptyOutputStream(64);
    }

    @Test
    void testBase32OutputStreamByChunk() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"JBSWY3DPEBLW64TMMQ======\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)"Hello World");
        this.testByChunk(encoded, decoded, 76, CR_LF);
        Base32 codec = new Base32();
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, 0, LF);
        }
    }

    @Test
    void testBase32OutputStreamByteByByte() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"JBSWY3DPEBLW64TMMQ======\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)"Hello World");
        this.testByteByByte(encoded, decoded, 76, CR_LF);
        Base32 codec = new Base32();
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, 0, LF);
        }
    }

    @Test
    void testBuilder() {
        Assertions.assertNotNull((Object)Base32OutputStream.builder().getBaseNCodec());
    }

    private void testByChunk(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (Base32OutputStream out = new Base32OutputStream((OutputStream)byteOut, true, chunkSize, separator);){
            out.write(decoded);
        }
        byte[] output = byteOut.toByteArray();
        Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming chunked Base32 encode");
        byteOut = new ByteArrayOutputStream();
        try (Object out = new Base32OutputStream((OutputStream)byteOut, false);){
            ((OutputStream)out).write(encoded);
        }
        output = byteOut.toByteArray();
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming chunked Base32 decode");
        byteOut = new ByteArrayOutputStream();
        out = byteOut;
        for (int i = 0; i < 10; ++i) {
            out = new Base32OutputStream((OutputStream)out, false);
            out = new Base32OutputStream((OutputStream)out, true, chunkSize, separator);
        }
        ((OutputStream)out).write(decoded);
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assertions.assertArrayEquals((byte[])decoded, (byte[])byteOut.toByteArray(), (String)"Streaming chunked Base32 wrap-wrap-wrap!");
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (Base32OutputStream out = new Base32OutputStream((OutputStream)byteOut, true, chunkSize, separator);){
            for (byte element : decoded) {
                out.write(element);
            }
        }
        byte[] output = byteOut.toByteArray();
        Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming byte-by-byte Base32 encode");
        byteOut = new ByteArrayOutputStream();
        try (Object out = new Base32OutputStream((OutputStream)byteOut, false);){
            for (byte element : encoded) {
                ((OutputStream)out).write(element);
            }
        }
        output = byteOut.toByteArray();
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming byte-by-byte Base32 decode");
        byteOut = new ByteArrayOutputStream();
        out = new Base32OutputStream((OutputStream)byteOut, false);
        try {
            for (byte element : encoded) {
                ((OutputStream)out).write(element);
                ((OutputStream)out).flush();
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        output = byteOut.toByteArray();
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming byte-by-byte flush() Base32 decode");
        byteOut = new ByteArrayOutputStream();
        out = byteOut;
        for (int i = 0; i < 10; ++i) {
            out = new Base32OutputStream((OutputStream)out, false);
            out = new Base32OutputStream((OutputStream)out, true, chunkSize, separator);
        }
        for (byte element : decoded) {
            ((OutputStream)out).write(element);
        }
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming byte-by-byte Base32 wrap-wrap-wrap!");
    }

    @Test
    void testStrictDecoding() throws Exception {
        for (String s : Base32Test.BASE32_IMPOSSIBLE_CASES) {
            byte[] encoded = StringUtils.getBytesUtf8((String)s);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try (Base32OutputStream out = new Base32OutputStream((OutputStream)bout, false);){
                Assertions.assertFalse((boolean)out.isStrictDecoding());
                out.write(encoded);
                out.close();
                Assertions.assertTrue((bout.size() > 0 ? 1 : 0) != 0);
                bout = new ByteArrayOutputStream();
                try (Base32OutputStream out2 = new Base32OutputStream((OutputStream)bout, false, 0, null, CodecPolicy.STRICT);){
                    Assertions.assertTrue((boolean)out2.isStrictDecoding());
                    Assertions.assertThrows(IllegalArgumentException.class, () -> out2.write(encoded));
                }
                out2 = ((Base32OutputStream.Builder)((Base32OutputStream.Builder)((Base32OutputStream.Builder)Base32OutputStream.builder().setOutputStream((OutputStream)bout)).setEncode(false)).setBaseNCodec((BaseNCodec)((Base32.Builder)((Base32.Builder)((Base32.Builder)Base32.builder().setLineLength(0)).setLineSeparator(null)).setDecodingPolicy(CodecPolicy.STRICT)).get())).get();
                try {
                    Assertions.assertTrue((boolean)out2.isStrictDecoding());
                    Assertions.assertThrows(IllegalArgumentException.class, () -> out2.write(encoded));
                }
                finally {
                    if (out2 != null) {
                        out2.close();
                    }
                }
                out2 = ((Base32OutputStream.Builder)((Base32OutputStream.Builder)((Base32OutputStream.Builder)Base32OutputStream.builder().setOutputStream((OutputStream)bout)).setEncode(false)).setBaseNCodec((BaseNCodec)((Base32.Builder)Base32.builder().setDecodingPolicy(CodecPolicy.STRICT)).get())).get();
                try {
                    Assertions.assertTrue((boolean)out2.isStrictDecoding());
                    Assertions.assertThrows(IllegalArgumentException.class, () -> out2.write(encoded));
                }
                finally {
                    if (out2 != null) {
                        out2.close();
                    }
                }
            }
        }
    }

    @Test
    void testWriteOutOfBounds() throws Exception {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (Base32OutputStream out = new Base32OutputStream((OutputStream)bout);){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> out.write(buf, -1, 1), (String)"Base32OutputStream.write(buf, -1, 1)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> out.write(buf, 1, -1), (String)"Base32OutputStream.write(buf, 1, -1)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> out.write(buf, buf.length + 1, 0), (String)"Base32OutputStream.write(buf, buf, buf.length + 1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> out.write(buf, buf.length - 1, 2), (String)"Base32OutputStream.write(buf, buf, buf.length - 1, 2)");
        }
    }

    @Test
    void testWriteToNullCoverage() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (Base32OutputStream out = new Base32OutputStream((OutputStream)bout);){
            Assertions.assertThrows(NullPointerException.class, () -> out.write(null, 0, 0));
        }
    }
}

