/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.LegacyMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataSerializer;
import org.apache.cassandra.utils.Pair;

public class Descriptor {
    public static String TMP_EXT = ".tmp";
    public final File directory;
    public final Version version;
    public final String ksname;
    public final String cfname;
    public final int generation;
    public final SSTableFormat.Type formatType;
    public final Component digestComponent;
    private final int hashCode;
    private static final String LEGACY_COMP_IN_PROG_REGEX_STR = "^compactions_in_progress(\\-[\\d,a-f]{32})?$";
    private static final Pattern LEGACY_COMP_IN_PROG_REGEX = Pattern.compile("^compactions_in_progress(\\-[\\d,a-f]{32})?$");
    private static final String LEGACY_TMP_REGEX_STR = "^((.*)\\-(.*)\\-)?tmp(link)?\\-((?:l|k).)\\-(\\d)*\\-(.*)$";
    private static final Pattern LEGACY_TMP_REGEX = Pattern.compile("^((.*)\\-(.*)\\-)?tmp(link)?\\-((?:l|k).)\\-(\\d)*\\-(.*)$");

    @VisibleForTesting
    public Descriptor(File directory, String ksname, String cfname, int generation) {
        this(SSTableFormat.Type.current().info.getLatestVersion(), directory, ksname, cfname, generation, SSTableFormat.Type.current(), null);
    }

    public Descriptor(File directory, String ksname, String cfname, int generation, SSTableFormat.Type formatType) {
        this(formatType.info.getLatestVersion(), directory, ksname, cfname, generation, formatType, Component.digestFor(formatType.info.getLatestVersion().uncompressedChecksumType()));
    }

    @VisibleForTesting
    public Descriptor(String version, File directory, String ksname, String cfname, int generation, SSTableFormat.Type formatType) {
        this(formatType.info.getVersion(version), directory, ksname, cfname, generation, formatType, Component.digestFor(formatType.info.getLatestVersion().uncompressedChecksumType()));
    }

    public Descriptor(Version version, File directory, String ksname, String cfname, int generation, SSTableFormat.Type formatType, Component digestComponent) {
        assert (version != null && directory != null && ksname != null && cfname != null && formatType.info.getLatestVersion().getClass().equals(version.getClass()));
        this.version = version;
        try {
            this.directory = directory.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.ksname = ksname;
        this.cfname = cfname;
        this.generation = generation;
        this.formatType = formatType;
        this.digestComponent = digestComponent;
        this.hashCode = Objects.hashCode((Object[])new Object[]{version, this.directory, generation, ksname, cfname, formatType});
    }

    public Descriptor withGeneration(int newGeneration) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, newGeneration, this.formatType, this.digestComponent);
    }

    public Descriptor withFormatType(SSTableFormat.Type newType) {
        return new Descriptor(newType.info.getLatestVersion(), this.directory, this.ksname, this.cfname, this.generation, newType, this.digestComponent);
    }

    public Descriptor withDigestComponent(Component newDigestComponent) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, this.generation, this.formatType, newDigestComponent);
    }

    public String tmpFilenameFor(Component component) {
        return this.filenameFor(component) + TMP_EXT;
    }

    public String filenameFor(Component component) {
        return this.baseFilename() + '-' + component.name();
    }

    public String baseFilename() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.directory).append(File.separatorChar);
        this.appendFileName(buff);
        return buff.toString();
    }

    private void appendFileName(StringBuilder buff) {
        if (!this.version.hasNewFileName()) {
            buff.append(this.ksname).append('-');
            buff.append(this.cfname).append('-');
        }
        buff.append(this.version).append('-');
        buff.append(this.generation);
        if (this.formatType != SSTableFormat.Type.LEGACY) {
            buff.append('-').append(this.formatType.name);
        }
    }

    public String relativeFilenameFor(Component component) {
        StringBuilder buff = new StringBuilder();
        if (Directories.isSecondaryIndexFolder(this.directory)) {
            buff.append(this.directory.getName()).append(File.separator);
        }
        this.appendFileName(buff);
        buff.append('-').append(component.name());
        return buff.toString();
    }

    public SSTableFormat getFormat() {
        return this.formatType.info;
    }

    public List<File> getTemporaryFiles() {
        File[] tmpFiles;
        ArrayList<File> ret = new ArrayList<File>();
        for (File tmpFile : tmpFiles = this.directory.listFiles((dir, name) -> name.endsWith(TMP_EXT))) {
            ret.add(tmpFile);
        }
        return ret;
    }

    public static boolean isLegacyFile(File file) {
        if (file.isDirectory()) {
            return file.getParentFile() != null && file.getParentFile().getName().equalsIgnoreCase("system") && LEGACY_COMP_IN_PROG_REGEX.matcher(file.getName()).matches();
        }
        return LEGACY_TMP_REGEX.matcher(file.getName()).matches();
    }

    public static boolean isValidFile(String fileName) {
        return fileName.endsWith(".db") && !LEGACY_TMP_REGEX.matcher(fileName).matches();
    }

    public static Descriptor fromFilename(String filename) {
        return Descriptor.fromFilename(filename, false);
    }

    public static Descriptor fromFilename(String filename, SSTableFormat.Type formatType) {
        return Descriptor.fromFilename(filename).withFormatType(formatType);
    }

    public static Descriptor fromFilename(String filename, boolean skipComponent) {
        File file = new File(filename).getAbsoluteFile();
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName(), (boolean)skipComponent).left;
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name) {
        return Descriptor.fromFilename(directory, name, false);
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name, boolean skipComponent) {
        String ksname;
        String cfname;
        File parentDirectory = directory != null ? directory : new File(".");
        StringTokenizer st = new StringTokenizer(name, String.valueOf('-'));
        ArrayDeque<String> tokenStack = new ArrayDeque<String>();
        while (st.hasMoreTokens()) {
            tokenStack.push(st.nextToken());
        }
        String component = skipComponent ? null : (String)tokenStack.pop();
        String nexttok = (String)tokenStack.pop();
        SSTableFormat.Type fmt = SSTableFormat.Type.LEGACY;
        if (!CharMatcher.DIGIT.matchesAllOf((CharSequence)nexttok)) {
            fmt = SSTableFormat.Type.validate(nexttok);
            nexttok = (String)tokenStack.pop();
        }
        int generation = Integer.parseInt(nexttok);
        nexttok = (String)tokenStack.pop();
        if (!Version.validate(nexttok)) {
            throw new UnsupportedOperationException("SSTable " + name + " is too old to open.  Upgrade to 2.0 first, and run upgradesstables");
        }
        Version version = fmt.info.getVersion(nexttok);
        if (version.hasNewFileName()) {
            File cfDirectory = parentDirectory;
            String indexName = "";
            if (Directories.isSecondaryIndexFolder(cfDirectory)) {
                indexName = cfDirectory.getName();
                cfDirectory = cfDirectory.getParentFile();
            }
            if (cfDirectory.getName().equals("backups")) {
                cfDirectory = cfDirectory.getParentFile();
            } else if (cfDirectory.getParentFile().getName().equals("snapshots")) {
                cfDirectory = cfDirectory.getParentFile().getParentFile();
            }
            cfname = cfDirectory.getName().split("-")[0] + indexName;
            ksname = cfDirectory.getParentFile().getName();
        } else {
            cfname = (String)tokenStack.pop();
            ksname = (String)tokenStack.pop();
        }
        assert (tokenStack.isEmpty()) : "Invalid file name " + name + " in " + directory;
        return Pair.create(new Descriptor(version, parentDirectory, ksname, cfname, generation, fmt, Component.digestFor(version.uncompressedChecksumType())), component);
    }

    public IMetadataSerializer getMetadataSerializer() {
        if (this.version.hasNewStatsFile()) {
            return new MetadataSerializer();
        }
        return new LegacyMetadataSerializer();
    }

    public boolean isCompatible() {
        return this.version.isCompatible();
    }

    public String toString() {
        return this.baseFilename();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return that.directory.equals(this.directory) && that.generation == this.generation && that.ksname.equals(this.ksname) && that.cfname.equals(this.cfname) && that.version.equals(this.version) && that.formatType == this.formatType;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

