/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate;

import org.apache.cassandra.stress.generate.Distribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;

public class DistributionOffsetApache
extends Distribution {
    final AbstractRealDistribution delegate;
    final long min;
    final long delta;

    public DistributionOffsetApache(AbstractRealDistribution delegate, long min, long max) {
        this.delegate = delegate;
        this.min = min;
        this.delta = max - min;
    }

    @Override
    public void setSeed(long seed) {
        this.delegate.reseedRandomGenerator(seed);
    }

    @Override
    public long next() {
        return this.offset(this.min, this.delta, this.delegate.sample());
    }

    @Override
    public double nextDouble() {
        return this.offsetDouble(this.min, this.delta, this.delegate.sample());
    }

    @Override
    public long inverseCumProb(double cumProb) {
        return this.offset(this.min, this.delta, this.delegate.inverseCumulativeProbability(cumProb));
    }

    private long offset(long min, long delta, double val) {
        long r = (long)val;
        if (r < 0L) {
            r = 0L;
        }
        if (r > delta) {
            r = delta;
        }
        return min + r;
    }

    private double offsetDouble(long min, long delta, double r) {
        if (r < 0.0) {
            r = 0.0;
        }
        if (r > (double)delta) {
            r = delta;
        }
        return (double)min + r;
    }
}

