---
layout: news_item
date: "2017-03-24 08:15:00 +0000"
author: jhyde
version: 1.12.0
categories: [release]
tag: v1-12-0
sha: ea7ace1
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

The [Apache Calcite PMC]({{ site.baseurl }})
is pleased to announce
[Apache Calcite release 1.12.0]({{ site.baseurl }}/docs/history.html#v1-12-0).

In 2&frac12; months,
[29 contributors have resolved 95 issues]({{ site.baseurl }}/docs/history.html#v1-12-0).
Here are some of the highlights.

Calcite now supports JDK 9 and Guava 21.0. (It continues to run on
JDK 7 and 8, and on versions of Guava as early as 14.0.1. The default
version of Guava remains 19.0, due to the Cassandra adapter's
dependencies, and the fact that Guava 21.0 requires JDK 8 or later.)

There are two new adapters:

* The [File adapter](https://issues.apache.org/jira/browse/CALCITE-884)
  can read files of various formats (such as CSV, JSON, zipped files,
  and HTML) over various protocols (including file and HTTP). If
  reading HTML files, it can extract data from nested `<TABLE>`
  elements.
* The [Pig adapter](https://issues.apache.org/jira/browse/CALCITE-1598)
  provides a SQL interface to [Apache Pig](https://pig.apache.org/).

And there are continuing improvements in performance and stability of
the Druid adapter. (The Druid project now
[embeds Calcite to provide SQL support](https://github.com/druid-io/druid/pull/3682),
and there has been cross-fertilization between the projects.)

To err is human, as the saying goes. If you mis-type the name of a
schema, table or column in a SQL statement, Calcite now
[helps you correct it](https://issues.apache.org/jira/browse/CALCITE-1549).
The error message indicates whether it was whether it was the schema,
table or column that was not found; if the mistake was just due to an
upper- or lower-case letter, it suggests the correct name.

New SQL syntax and functions:

* `HOP`, `TUMBLE` and `SESSION` functions in the `GROUP BY` clause
  allow you to aggregate over window types (especially useful for
  streaming queries);
* Experimental support for the `MATCH_RECOGNIZE` clause for
  Complex-Event Processing (CEP);
* New `YEAR`, `MONTH`, `WEEK`, `DAYOFYEAR`, `DAYOFMONTH`, `DAYOFWEEK`,
  `HOUR`, `MINUTE`, `SECOND`, `DATABASE`, `IFNULL`, and `USER`
  functions to comply with the ODBC/JDBC standard. Also, `EXTRACT` now
  allows the corresponding time-unit arguments.
