/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.server.log;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.openjdk.tools.sjavac.Log;

public class LazyInitFileLog
extends Log {
    String baseFilename;
    Path destination = null;

    public LazyInitFileLog(String string) {
        super(null, null);
        this.baseFilename = string;
    }

    @Override
    protected void printLogMsg(Log.Level level, String string) {
        try {
            if (this.out == null && this.isLevelLogged(level)) {
                this.destination = this.getAvailableDestination();
                this.out = this.err = new PrintWriter((Writer)new FileWriter(this.destination.toFile()), true);
            }
            super.printLogMsg(level, string);
        }
        catch (IOException iOException) {
            System.out.println("IO error occurred: " + iOException.getMessage());
            System.out.println("Original message: [" + (Object)((Object)level) + "] " + string);
        }
    }

    private Path getAvailableDestination() {
        Path path = Paths.get(this.baseFilename, new String[0]);
        int n = 1;
        while (Files.exists(path, new LinkOption[0])) {
            path = Paths.get(this.baseFilename + "." + n++, new String[0]);
        }
        return path;
    }

    public Path getLogDestination() {
        return this.destination;
    }
}

