% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{concat_tables}
\alias{concat_tables}
\title{Concatenate one or more Tables}
\usage{
concat_tables(..., unify_schemas = TRUE)
}
\arguments{
\item{...}{One or more \link{Table} or \link{RecordBatch} objects. RecordBatch objects
will be automatically converted to Tables.}

\item{unify_schemas}{If TRUE, the schemas of the tables will be first unified
with fields of the same name being merged, then each table will be promoted
to the unified schema before being concatenated. Otherwise, all tables should
have the same schema.}
}
\description{
Concatenate one or more \link{Table} objects into a single table. This operation
does not copy array data, but instead creates new chunked arrays for each
column that point at existing array data.
}
\examples{
tbl <- arrow_table(name = rownames(mtcars), mtcars)
prius <- arrow_table(name = "Prius", mpg = 58, cyl = 4, disp = 1.8)
combined <- concat_tables(tbl, prius)
tail(combined)$to_data_frame()

# Can also pass RecordBatch objects
batch <- record_batch(name = "Volt", mpg = 53, cyl = 4, disp = 1.5)
combined2 <- concat_tables(tbl, batch)
}
