/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.Reader;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonProviderImpl;
import org.apache.activemq.artemis.commons.shaded.json.JsonReader;
import org.apache.activemq.artemis.commons.shaded.json.spi.JsonProvider;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.impl.JsonArrayBuilderImpl;
import org.apache.activemq.artemis.json.impl.JsonArrayImpl;
import org.apache.activemq.artemis.json.impl.JsonObjectBuilderImpl;
import org.apache.activemq.artemis.json.impl.JsonObjectImpl;

public class JsonLoader {
    private static final JsonProvider provider = new JsonProviderImpl();

    public static JsonObject readObject(Reader reader) {
        try (JsonReader jsonReader = provider.createReader(reader);){
            JsonObjectImpl jsonObjectImpl = new JsonObjectImpl(jsonReader.readObject());
            return jsonObjectImpl;
        }
    }

    public static JsonArray readArray(Reader reader) {
        try (JsonReader jsonReader = provider.createReader(reader);){
            JsonArrayImpl jsonArrayImpl = new JsonArrayImpl(jsonReader.readArray());
            return jsonArrayImpl;
        }
    }

    public static JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(provider.createArrayBuilder());
    }

    public static JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(provider.createObjectBuilder());
    }
}

