/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model.context;

import java.util.List;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.ListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.ListBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateListStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.ItemsSwtObservableInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.databinding.rcp.DatabindingTestUtils;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.junit.jupiter.api.Test;

public class BindListTest
extends AbstractBindingTest {
    @Test
    public void test_bindList() throws Exception {
        BindListTest.setFileContentSrc("test/TestBean.java", BindListTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.List getNames() {", "    return null;", "  }", "}"));
        BindListTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Combo m_combo;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_combo = new Combo(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableList observeList = BeanProperties.list(\"names\").observe(m_bean);", "    IObservableList observeWidget = WidgetProperties.items().observe(m_combo);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindList(observeWidget, observeList, null, null);", "    return bindingContext;", "  }", "}"});
        BindListTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindListTest.assertNotNull((Object)bindings);
        BindListTest.assertEquals((int)1, (int)bindings.size());
        BindListTest.assertInstanceOf(ListBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BindListTest.assertNotNull((Object)binding.getTarget());
        BindListTest.assertNotNull((Object)binding.getTargetProperty());
        BindListTest.assertNotNull((Object)binding.getTargetObservable());
        BindListTest.assertSame((Object)binding.getTarget(), (Object)binding.getTargetObservable().getBindableObject());
        BindListTest.assertSame((Object)binding.getTargetProperty(), (Object)binding.getTargetObservable().getBindableProperty());
        BindListTest.assertInstanceOf(ItemsSwtObservableInfo.class, (Object)binding.getTargetObservable());
        BindListTest.assertEquals((Object)"observeWidget", (Object)binding.getTargetObservable().getVariableIdentifier());
        BindListTest.assertNotNull((Object)binding.getModel());
        BindListTest.assertNotNull((Object)binding.getModelProperty());
        BindListTest.assertNotNull((Object)binding.getModelObservable());
        BindListTest.assertSame((Object)binding.getModel(), (Object)binding.getModelObservable().getBindableObject());
        BindListTest.assertSame((Object)binding.getModelProperty(), (Object)binding.getModelObservable().getBindableProperty());
        BindListTest.assertInstanceOf(ListBeanObservableInfo.class, (Object)binding.getModelObservable());
        BindListTest.assertEquals((Object)"observeList", (Object)binding.getModelObservable().getVariableIdentifier());
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateListStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateListStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
    }

    @Test
    public void test_strategy_constructors_1() throws Exception {
        this.strategy_constructors("    bindingContext.bindList(observeWidget, observeList, new UpdateListStrategy(), new UpdateListStrategy(UpdateListStrategy.POLICY_NEVER));", UpdateListStrategyInfo.Value.POLICY_NEVER, "POLICY_NEVER|POLICY_NEVER");
    }

    @Test
    public void test_strategy_constructors_2() throws Exception {
        this.strategy_constructors("    bindingContext.bindList(observeWidget, observeList, new UpdateListStrategy(), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));", UpdateListStrategyInfo.Value.POLICY_ON_REQUEST, "POLICY_ON_REQUEST|POLICY_ON_REQUEST");
    }

    @Test
    public void test_strategy_constructors_3() throws Exception {
        this.strategy_constructors("    bindingContext.bindList(observeWidget, observeList, new UpdateListStrategy(), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));", UpdateListStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
    }

    private void strategy_constructors(String line, Object value, String presentation) throws Exception {
        BindListTest.setFileContentSrc("test/TestBean.java", BindListTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.List getNames() {", "    return null;", "  }", "}"));
        BindListTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Combo m_combo;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_combo = new Combo(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableList observeList = BeanProperties.list(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableList observeWidget = WidgetProperties.items().observe(m_combo);", "    DataBindingContext bindingContext = new DataBindingContext();", line, "    return bindingContext;", "  }", "}"});
        BindListTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindListTest.assertNotNull((Object)bindings);
        BindListTest.assertEquals((int)1, (int)bindings.size());
        BindListTest.assertInstanceOf(ListBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateListStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.IntConstructor, value, presentation);
    }

    @Test
    public void test_strategy_variable() throws Exception {
        BindListTest.setFileContentSrc("test/TestBean.java", BindListTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.List getNames() {", "    return null;", "  }", "}"));
        BindListTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Combo m_combo;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_combo = new Combo(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableList observeList = BeanProperties.list(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableList observeWidget = WidgetProperties.items().observe(m_combo);", "    DataBindingContext bindingContext = new DataBindingContext();", "    UpdateListStrategy strategy0 = new UpdateListStrategy();", "    UpdateListStrategy strategy1 = new UpdateListStrategy(UpdateListStrategy.POLICY_NEVER);", "    bindingContext.bindList(observeWidget, observeList, strategy0, strategy1);", "    return bindingContext;", "  }", "}"});
        BindListTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindListTest.assertNotNull((Object)bindings);
        BindListTest.assertEquals((int)1, (int)bindings.size());
        BindListTest.assertInstanceOf(ListBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), "strategy0", UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateListStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), "strategy1", UpdateStrategyInfo.StrategyType.IntConstructor, UpdateListStrategyInfo.Value.POLICY_NEVER, "POLICY_NEVER|POLICY_NEVER");
    }

    @Test
    public void test_strategy_extendet() throws Exception {
        this.createModelCompilationUnit("test", "TestStrategy.java", DatabindingTestUtils.getTestSource("public class TestStrategy extends UpdateListStrategy {", "  public TestStrategy() {", "  }", "}"));
        BindListTest.waitForAutoBuild();
        BindListTest.setFileContentSrc("test/TestBean.java", BindListTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.List getNames() {", "    return null;", "  }", "}"));
        BindListTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Combo m_combo;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_combo = new Combo(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableList observeList = BeanProperties.list(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableList observeWidget = WidgetProperties.items().observe(m_combo);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindList(observeWidget, observeList, null, new test.TestStrategy());", "    return bindingContext;", "  }", "}"});
        BindListTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindListTest.assertNotNull((Object)bindings);
        BindListTest.assertEquals((int)1, (int)bindings.size());
        BindListTest.assertInstanceOf(ListBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateListStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.ExtendetClass, "test.TestStrategy", "test.TestStrategy|test.TestStrategy");
    }

    @Test
    public void test_strategy_converter_1() throws Exception {
        this.strategy_converter("    strategy.setConverter(new TestConverter());", "    //", "null|test.TestConverter|TestConverter");
    }

    @Test
    public void test_strategy_converter_2() throws Exception {
        this.strategy_converter("    TestConverter converter = new TestConverter();", "    strategy.setConverter(converter);", "converter|test.TestConverter|TestConverter");
    }

    private void strategy_converter(String line0, String line1, String testString) throws Exception {
        this.createModelCompilationUnit("test", "TestConverter.java", DatabindingTestUtils.getTestSource("public class TestConverter extends Converter {", "  public TestConverter() {", "    super(null, null);", "  }", "  public Object convert(Object fromObject) {", "    return null;", "  }", "}"));
        BindListTest.waitForAutoBuild();
        BindListTest.setFileContentSrc("test/TestBean.java", BindListTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.List getNames() {", "    return null;", "  }", "}"));
        BindListTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Combo m_combo;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_combo = new Combo(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableList observeList = BeanProperties.list(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableList observeWidget = WidgetProperties.items().observe(m_combo);", "    DataBindingContext bindingContext = new DataBindingContext();", "    UpdateListStrategy strategy = new UpdateListStrategy();", line0, line1, "    bindingContext.bindList(observeWidget, observeList, null, strategy);", "    return bindingContext;", "  }", "}"});
        BindListTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindListTest.assertNotNull((Object)bindings);
        BindListTest.assertEquals((int)1, (int)bindings.size());
        BindListTest.assertInstanceOf(ListBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateListStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), "strategy", UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateListStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE", testString);
    }

    private void assertStrategy(Object objectStrategy, String variable, Object type, Object value, String presentation) throws Exception {
        this.assertStrategy(objectStrategy, variable, type, value, presentation, null);
    }

    private void assertStrategy(Object objectStrategy, String variable, Object type, Object value, String presentation, String converter) throws Exception {
        BindListTest.assertNotNull((Object)objectStrategy);
        BindListTest.assertInstanceOf(UpdateListStrategyInfo.class, (Object)objectStrategy);
        UpdateListStrategyInfo strategy = (UpdateListStrategyInfo)objectStrategy;
        if (variable == null) {
            BindListTest.assertNull((Object)strategy.getVariableIdentifier());
        } else {
            BindListTest.assertEquals((Object)variable, (Object)strategy.getVariableIdentifier());
        }
        BindListTest.assertEquals((Object)type, (Object)strategy.getStrategyType());
        BindListTest.assertEquals((Object)value, (Object)strategy.getStrategyValue());
        BindListTest.assertEquals((Object)presentation, (Object)(strategy.getStringValue() + "|" + strategy.getPresentationText()));
        if (converter == null) {
            BindListTest.assertNull((Object)strategy.getConverter());
        } else {
            BindListTest.assertEquals((Object)converter, (Object)(strategy.getConverter().getVariableIdentifier() + "|" + strategy.getConverter().getClassName() + "|" + strategy.getConverter().getPresentationText()));
        }
    }
}

