/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class CreationDescriptionLoadingTest
extends SwingModelTest {
    private Class<?> m_myButtonClass;

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.m_myButtonClass = null;
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_load_noId() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton()]]></source>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        CreationDescription creation = description.getCreation(null);
        CreationDescriptionLoadingTest.assertNull((Object)creation.getId());
        CreationDescriptionLoadingTest.assertEquals((Object)"MyButton", (Object)creation.getName());
        CreationDescriptionLoadingTest.assertEquals((Object)"new test.MyButton()", (Object)creation.getSource());
        CreationDescriptionLoadingTest.assertEquals((int)0, (int)creation.getInvocations().size());
    }

    @Test
    public void test_load_withName() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation id='withName' name='my unique name'>", "    <source><![CDATA[new test.MyButton()]]></source>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        String id = "withName";
        CreationDescription creation = description.getCreation(id);
        CreationDescriptionLoadingTest.assertEquals((Object)id, (Object)creation.getId());
        CreationDescriptionLoadingTest.assertEquals((Object)"my unique name", (Object)creation.getName());
        CreationDescriptionLoadingTest.assertEquals((Object)"new test.MyButton()", (Object)creation.getSource());
        CreationDescriptionLoadingTest.assertEquals((int)0, (int)creation.getInvocations().size());
    }

    @Test
    public void test_load_forDescription() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <description>type level description</description>", "  <creation id='noDescription'>", "    <source><![CDATA[new test.MyButton()]]></source>", "  </creation>", "  <creation id='withDescription'>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <description>creation level description</description>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        CreationDescriptionLoadingTest.assertEquals((Object)"type level description", (Object)description.getDescription());
        String id = "noDescription";
        CreationDescription creation = description.getCreation(id);
        CreationDescriptionLoadingTest.assertEquals((Object)id, (Object)creation.getId());
        CreationDescriptionLoadingTest.assertEquals((Object)"type level description", (Object)creation.getDescription());
        id = "withDescription";
        creation = description.getCreation(id);
        CreationDescriptionLoadingTest.assertEquals((Object)id, (Object)creation.getId());
        CreationDescriptionLoadingTest.assertEquals((Object)"creation level description", (Object)creation.getDescription());
    }

    @Test
    public void test_load_wrappedDescription() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <description>type", "    level    description</description>", "  <creation id='withDescription'>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <description>creation", "        level    description</description>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        CreationDescription creation = description.getCreation(null);
        CreationDescriptionLoadingTest.assertEquals((Object)"type level description", (Object)creation.getDescription());
        creation = description.getCreation("withDescription");
        CreationDescriptionLoadingTest.assertEquals((Object)"creation level description", (Object)creation.getDescription());
    }

    @Test
    public void test_load_forIcon() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton()]]></source>", "  </creation>", "  <creation id='withIcon'>", "    <source><![CDATA[new test.MyButton()]]></source>", "  </creation>", "</component>"));
        TestUtils.createImagePNG(m_testProject, "src/test/MyButton_withIcon.png", 10, 10);
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        String id = null;
        CreationDescription creation = description.getCreation(id);
        CreationDescriptionLoadingTest.assertEquals(id, (Object)creation.getId());
        ImageDescriptor creationIcon = creation.getIcon();
        CreationDescriptionLoadingTest.assertNotNull((Object)creationIcon);
        CreationDescriptionLoadingTest.assertSame((Object)description.getIcon(), (Object)creationIcon);
        CreationDescriptionLoadingTest.assertEquals((int)16, (int)creationIcon.getImageData((int)100).width);
        CreationDescriptionLoadingTest.assertEquals((int)16, (int)creationIcon.getImageData((int)100).height);
        id = "withIcon";
        creation = description.getCreation(id);
        CreationDescriptionLoadingTest.assertEquals((Object)id, (Object)creation.getId());
        creationIcon = creation.getIcon();
        CreationDescriptionLoadingTest.assertNotNull((Object)creationIcon);
        CreationDescriptionLoadingTest.assertNotSame((Object)description.getIcon(), (Object)creationIcon);
        CreationDescriptionLoadingTest.assertEquals((int)10, (int)creationIcon.getImageData((int)100).width);
        CreationDescriptionLoadingTest.assertEquals((int)10, (int)creationIcon.getImageData((int)100).height);
    }

    @Test
    public void test_load_withPattern() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation id='withPattern'>", "    <source><![CDATA[new %component.class%()]]></source>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        String id = "withPattern";
        CreationDescription creation = description.getCreation(id);
        CreationDescriptionLoadingTest.assertEquals((Object)id, (Object)creation.getId());
        CreationDescriptionLoadingTest.assertEquals((Object)"MyButton", (Object)creation.getName());
        CreationDescriptionLoadingTest.assertEquals((Object)"new test.MyButton()", (Object)creation.getSource());
        CreationDescriptionLoadingTest.assertEquals((int)0, (int)creation.getInvocations().size());
    }

    @Test
    public void test_load_withInvocation() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation id='withInvocation'>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <invocation signature='setText(java.lang.String)'><![CDATA['some text']]></invocation>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        String id = "withInvocation";
        CreationDescription creation = description.getCreation(id);
        CreationDescriptionLoadingTest.assertEquals((Object)id, (Object)creation.getId());
        CreationDescriptionLoadingTest.assertEquals((Object)"MyButton", (Object)creation.getName());
        CreationDescriptionLoadingTest.assertEquals((Object)"new test.MyButton()", (Object)creation.getSource());
        CreationDescriptionLoadingTest.assertEquals((int)1, (int)creation.getInvocations().size());
        CreationInvocationDescription invocation = (CreationInvocationDescription)creation.getInvocations().get(0);
        CreationDescriptionLoadingTest.assertEquals((Object)"setText(java.lang.String)", (Object)invocation.getSignature());
        CreationDescriptionLoadingTest.assertEquals((Object)"\"some text\"", (Object)invocation.getArguments());
    }

    @Test
    public void test_load_withParameters() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation id='withParameters'>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <parameter name='name_1'>value_1</parameter>", "    <parameter name='name_2'>value_2</parameter>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        String id = "withParameters";
        CreationDescription creation = description.getCreation(id);
        CreationDescriptionLoadingTest.assertEquals((Object)id, (Object)creation.getId());
        CreationDescriptionLoadingTest.assertEquals((Object)"MyButton", (Object)creation.getName());
        CreationDescriptionLoadingTest.assertEquals((Object)"new test.MyButton()", (Object)creation.getSource());
        Assertions.assertThat((Map)creation.getParameters()).contains(new Map.Entry[]{MapEntry.entry((Object)"name_1", (Object)"value_1"), MapEntry.entry((Object)"name_2", (Object)"value_2")});
    }

    @Test
    public void test_load_withTag() throws Exception {
        this.prepareMyButton();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <tag name='testTag1' value='true'/>", "    <tag name='testTag2' value='tag2value'/>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        CreationDescription creation = description.getCreation(null);
        CreationDescriptionLoadingTest.assertTrue((boolean)creation.hasTrueTag("testTag1"));
        CreationDescriptionLoadingTest.assertEquals((Object)creation.getTag("testTag2"), (Object)"tag2value");
        CreationDescriptionLoadingTest.assertNull((Object)creation.getTag("testTag3"));
        CreationDescriptionLoadingTest.assertFalse((boolean)creation.hasTrueTag("testTag3"));
    }

    @Test
    public void test_load_withTypeParameters() throws Exception {
        this.prepareContext();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton<T extends java.lang.Number> extends JButton {", "  public MyButton() {", "  }", "}"));
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.wbp-component.xml", CreationDescriptionLoadingTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton<%T%>()]]></source>", "    <typeParameters>", "      <typeParameter name='T' type='java.lang.Number' title='Generic type &lt;T&gt;'/>", "    </typeParameters>", "  </creation>", "</component>"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        this.m_myButtonClass = this.m_lastLoader.loadClass("test.MyButton");
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        CreationDescription creation = description.getCreation(null);
        Map typeParameters = creation.getTypeParameters();
        CreationDescriptionLoadingTest.assertNotNull((Object)typeParameters);
        CreationDescription.TypeParameterDescription parameter = (CreationDescription.TypeParameterDescription)typeParameters.get("T");
        CreationDescriptionLoadingTest.assertNotNull((Object)parameter);
        CreationDescriptionLoadingTest.assertEquals((Object)"java.lang.Number", (Object)parameter.getTypeName());
        CreationDescriptionLoadingTest.assertEquals((Object)"Generic type <T>", (Object)parameter.getTitle());
    }

    @Test
    public void test_defaultCreation_forObject() throws Exception {
        this.prepareContext();
        class MyPanel {
            MyPanel() {
            }
        }
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, MyPanel.class);
        CreationDescription creation = description.getCreation(null);
        CreationDescriptionLoadingTest.assertNotNull((Object)creation);
        CreationDescriptionLoadingTest.assertEquals((Object)("new " + ReflectionUtils.getCanonicalName(MyPanel.class) + "()"), (Object)creation.getSource());
    }

    @Test
    public void test_defaultCreation_forComponent() throws Exception {
        this.prepareContext();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(int a, String b, java.util.List c) {", "  }", "}"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        this.m_myButtonClass = this.m_lastLoader.loadClass("test.MyButton");
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_myButtonClass);
        CreationDescription creation = description.getCreation(null);
        CreationDescriptionLoadingTest.assertEquals((Object)"new test.MyButton(0, (java.lang.String) null, (java.util.List) null)", (Object)creation.getSource());
    }

    private void prepareMyButton() throws Exception {
        this.prepareContext();
        CreationDescriptionLoadingTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton() {", "  }", "}"));
        CreationDescriptionLoadingTest.waitForAutoBuild();
        this.m_myButtonClass = this.m_lastLoader.loadClass("test.MyButton");
    }

    private void prepareContext() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    // filler filler filler", "  }", "}");
    }
}

