/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.ZipFileFactory;
import org.eclipse.wb.tests.designer.tests.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

public final class TestBundle {
    private final BundleContext m_context = Activator.getDefault().getBundle().getBundleContext();
    private final String m_id;
    private final File m_bundleFolder;
    private File m_bundleFile;
    private boolean m_created;
    private Bundle m_bundle;
    private static int m_nextExtensionId = 0;
    private final List<ExtensionDeclaration> m_extensions = new ArrayList<ExtensionDeclaration>();

    public TestBundle() throws Exception {
        this("org.eclipse.wb.tests.testBundle");
    }

    public TestBundle(String id) throws Exception {
        this.m_id = id;
        this.m_bundleFile = this.m_bundleFolder = IOUtils2.createTempDirectory((String)"wbpTestBundle", (String)"");
    }

    public void addClass(Class<?> clazz) throws Exception {
        ClassLoader classLoader = clazz.getClassLoader();
        String name = clazz.getName();
        this.addClass(classLoader, name);
        try {
            int i = 1;
            while (true) {
                this.addClass(classLoader, name + "$" + i);
                ++i;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void addClass(ClassLoader classLoader, String name) throws Exception {
        this.addClass(name, TestBundle.getClassBytes(classLoader, name));
    }

    public void addClass(String name, InputStream inputStream) throws Exception {
        this.assertNotCreated();
        File classFile = this.getFileInExistingFolder(name.replace('.', '/') + ".class");
        IOUtils2.writeBytes((File)classFile, (InputStream)inputStream);
    }

    public void setFile(String path, String content) throws Exception {
        this.setFile(path, content.getBytes());
    }

    public void setFile(String path, byte[] content) throws Exception {
        this.assertNotCreated();
        File file = this.getFileInExistingFolder(path);
        IOUtils2.writeBytes((File)file, (byte[])content);
    }

    public ZipFileFactory addJar(String path) throws Exception {
        this.assertNotCreated();
        File jarFile = this.getFileInExistingFolder(path);
        return new ZipFileFactory(new FileOutputStream(jarFile));
    }

    private void assertNotCreated() {
        Assert.isTrue((!this.m_created ? 1 : 0) != 0, (String)"Bundle %s is already created.", (Object[])new Object[]{this.m_id});
    }

    private File getFileInExistingFolder(String path) {
        File file = new File(this.m_bundleFolder, path);
        file.getParentFile().mkdirs();
        return file;
    }

    public void addExtension(String pointId, String ... lines) {
        ExtensionDeclaration extension = new ExtensionDeclaration();
        extension.m_pointId = pointId;
        extension.m_id = "test_" + m_nextExtensionId++;
        extension.m_qualifiedId = this.m_id + "." + extension.m_id;
        extension.m_lines = lines;
        this.m_extensions.add(extension);
    }

    public void setPluginExtensions() throws Exception {
        Object content = "";
        content = (String)content + "<plugin>\n";
        for (ExtensionDeclaration extension : this.m_extensions) {
            content = (String)content + "\t<extension point='" + extension.m_pointId + "' id='" + extension.m_id + "'>\n";
            content = (String)content + "\t\t" + StringUtils.join((Object[])extension.m_lines, (String)"\n\t\t");
            content = (String)content + "\n";
            content = (String)content + "\t</extension>\n";
        }
        content = (String)content + "</plugin>";
        this.setFile("plugin.xml", (String)content);
    }

    private void waitForExtensionsInstalled() {
        while (!this.areAllExtensionsInstalled()) {
            TestUtils.waitEventLoop(1);
        }
    }

    private void waitForExtensionsUnInstalled() {
        while (!this.areAllExtensionsUnInstalled()) {
            TestUtils.waitEventLoop(1);
        }
    }

    private boolean areAllExtensionsInstalled() {
        for (ExtensionDeclaration extension : this.m_extensions) {
            if (extension.isInstalled()) continue;
            return false;
        }
        return true;
    }

    private boolean areAllExtensionsUnInstalled() {
        for (ExtensionDeclaration extension : this.m_extensions) {
            if (!extension.isInstalled()) continue;
            return false;
        }
        return true;
    }

    public static InputStream getClassBytes(Class<?> clazz) {
        return TestBundle.getClassBytes(clazz.getClassLoader(), clazz.getName());
    }

    public static InputStream getClassBytes(ClassLoader classLoader, String className) {
        String bytesPath = className.replace('.', '/') + ".class";
        InputStream inputStream = classLoader.getResourceAsStream(bytesPath);
        Assert.isNotNull((Object)inputStream, (String)"Unable to find %s bytes.", (Object[])new Object[]{className});
        return inputStream;
    }

    public void install() throws Exception {
        this.install(false);
    }

    public void install(boolean pack2jar) throws Exception {
        if (!this.m_extensions.isEmpty()) {
            this.setPluginExtensions();
        }
        this.install0(pack2jar);
        this.waitForExtensionsInstalled();
    }

    private void install0(boolean pack2jar) throws Exception, BundleException {
        this.doCreate(pack2jar);
        this.doInstall();
        this.m_bundle.start();
    }

    private void doCreate(boolean pack2jar) throws Exception {
        this.setFile("META-INF/MANIFEST.MF", StringUtils.join((Object[])new String[]{"Manifest-Version: 1.0", "Bundle-ManifestVersion: 2", MessageFormat.format("Bundle-SymbolicName: {0};singleton:=true", this.m_id), "Bundle-Version: 1.0.0", "Bundle-ClassPath: .", "Require-Bundle: org.eclipse.wb.core,org.eclipse.wb.core.java", "Bundle-ActivationPolicy: lazy"}, (String)"\n"));
        if (pack2jar) {
            this.pack2jar();
        }
        this.m_created = true;
    }

    private void pack2jar() throws Exception {
        File bundleJarFile = new File(this.m_bundleFolder.getParent(), this.m_id + ".jar");
        ZipFileFactory jarFile = new ZipFileFactory(new FileOutputStream(bundleJarFile));
        this.pack2jar(this.m_bundleFolder, jarFile, "");
        jarFile.close();
        this.m_bundleFile = bundleJarFile;
    }

    private void pack2jar(File folder, ZipFileFactory jar, String root) throws Exception {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                jar.add(root + file.getName(), new FileInputStream(file));
            }
            if (file.isDirectory()) {
                this.pack2jar(file, jar, root + file.getName() + "/");
            }
            file.delete();
            ++n2;
        }
        folder.delete();
    }

    private void doInstall() throws Exception {
        this.m_bundle = this.m_context.installBundle(this.m_bundleFile.toURI().toURL().toExternalForm());
    }

    public void uninstall() throws Exception {
        Assert.isNotNull((Object)this.m_bundle, (String)"Bundle %s is not installed.", (Object[])new Object[]{this.m_id});
        final AtomicBoolean uninstallEventProcessed = new AtomicBoolean();
        this.m_context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 16 && event.getBundle() == TestBundle.this.m_bundle) {
                    uninstallEventProcessed.set(true);
                    TestBundle.this.m_context.removeBundleListener((BundleListener)this);
                }
            }
        });
        this.m_bundle.uninstall();
        while (!uninstallEventProcessed.get()) {
            try {
                Thread.sleep(0L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.waitForExtensionsUnInstalled();
        this.m_bundle = null;
    }

    public void dispose() throws Exception {
        if (this.m_bundle != null) {
            this.uninstall();
        }
        FileUtils.deleteDirectory((File)this.m_bundleFolder);
        this.m_bundleFile.delete();
    }

    public void waitForExtension(String pointId, String extensionId) throws Exception {
        String qualifiedExtensionId = this.m_id + "." + extensionId;
        while (ExternalFactoriesHelper.getExtension((String)pointId, (String)qualifiedExtensionId) == null) {
            TestUtils.waitEventLoop(0);
        }
    }

    public void waitForNoExtension(String pointId, String extensionId) throws Exception {
        String qualifiedExtensionId = this.m_id + "." + extensionId;
        while (ExternalFactoriesHelper.getExtension((String)pointId, (String)qualifiedExtensionId) != null) {
            TestUtils.waitEventLoop(0);
        }
    }

    public String getId() {
        return this.m_id;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    private static class ExtensionDeclaration {
        String m_pointId;
        String m_id;
        String m_qualifiedId;
        String[] m_lines;

        private ExtensionDeclaration() {
        }

        boolean isInstalled() {
            return ExternalFactoriesHelper.getExtension((String)this.m_pointId, (String)this.m_qualifiedId) != null;
        }
    }
}

