/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.FigureUtils;

public final class VerticalLabel
extends Label {
    private Dimension m_preferredSize;

    protected void paintFigure(Graphics graphics) {
        graphics.fillRectangle(this.getBounds());
        Rectangle r = this.getClientArea();
        graphics.translate(r.getLocation());
        graphics.translate(r.width, 0);
        graphics.rotate(90.0f);
        graphics.drawText(this.getText(), 0, 0);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.m_preferredSize == null) {
            this.m_preferredSize = FigureUtils.calculateTextSize(this.getText(), this.getFont());
            Insets insets = this.getInsets();
            this.m_preferredSize.expand(insets.getWidth(), insets.getHeight());
            this.m_preferredSize.transpose();
        }
        return this.m_preferredSize;
    }

    public void invalidate() {
        this.m_preferredSize = null;
        super.invalidate();
    }
}

