/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wb.core.controls.BrowserComposite;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.actions.SwitchAction;
import org.eclipse.wb.internal.core.editor.errors.ErrorEntryInfo;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.exception.NoEntryPointError;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class NoEntryPointComposite
extends Composite {
    private final BrowserComposite m_browser;
    private final Label m_titleLabel;
    private final TableViewer m_viewer;
    private AstEditor m_editor;
    private TypeDeclaration m_typeDeclaration;

    public NoEntryPointComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.create((Composite)this);
        Composite titleComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)titleComposite).alignHL();
        GridLayoutFactory.create((Composite)titleComposite).columns(2).margins(10);
        Label label = new Label(titleComposite, 0);
        label.setImage(parent.getDisplay().getSystemImage(2));
        Font boldFont = FontDescriptor.createFrom((Font)this.getFont()).setHeight(14).setStyle(1).createFont(null);
        this.m_titleLabel = new Label(titleComposite, 0);
        this.m_titleLabel.setFont(boldFont);
        this.m_titleLabel.addDisposeListener(event -> boldFont.dispose());
        this.m_browser = new BrowserComposite((Composite)this, 0);
        GridDataFactory.create((Control)this.m_browser).grab().fill();
        new Label((Composite)this, 0).setText(Messages.NoEntryPointComposite_viewerLabel);
        this.m_viewer = new TableViewer((Composite)this, 2560);
        Table table = this.m_viewer.getTable();
        GridDataFactory.create((Control)table).hintVC(10).grabH().fill();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.m_viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NoEntryPointComposite.this.markSelectedMethod();
            }
        });
        Composite buttonsComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)buttonsComposite).alignHR();
        GridLayoutFactory.create((Composite)buttonsComposite).columns(2).equalColumns().marginsH(0);
        Button selectButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)selectButton).fillH();
        selectButton.setText(Messages.NoEntryPointComposite_useButton);
        selectButton.setImage(EnvironmentUtils.IS_MAC ? null : DesignerPlugin.getImage((String)"actions/errors/entry_point.png"));
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NoEntryPointComposite.this.markSelectedMethod();
            }
        });
        Button switchButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)switchButton).fillH();
        switchButton.setText(Messages.NoEntryPointComposite_switchToCodeButton);
        switchButton.setImage(EnvironmentUtils.IS_MAC ? null : DesignerPlugin.getImage((String)"actions/errors/switch32.png"));
        switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new SwitchAction().run();
            }
        });
    }

    public void setException(NoEntryPointError e) {
        this.m_editor = e.getEditor();
        this.m_typeDeclaration = e.getTypeDeclaration();
        int code = 100;
        ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry((int)code, (Object[])new Object[0]);
        this.m_titleLabel.setText(entry.getTitle());
        this.m_browser.setText(DesignerExceptionUtils.getWarningHTML((ErrorEntryInfo)entry));
        try {
            this.m_viewer.setInput(this.getPossibleEntryPoints());
            this.m_viewer.getTable().setSelection(0);
        }
        catch (Throwable ex) {
            DesignerPlugin.log((Throwable)ex);
        }
    }

    private List<IMethod> getPossibleEntryPoints() throws Exception {
        String typeName = AstNodeUtils.getFullyQualifiedName(this.m_typeDeclaration, false);
        IType type = this.m_editor.getJavaProject().findType(typeName);
        ArrayList<IMethod> methods = new ArrayList<IMethod>(Arrays.asList(type.getMethods()));
        NoEntryPointComposite.sortMethods(methods);
        return methods;
    }

    private static void sortMethods(List<IMethod> methods) {
        Collections.sort(methods, new Comparator<IMethod>(){

            @Override
            public int compare(IMethod o1, IMethod o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            private int getPriority(IMethod method) {
                block4: {
                    if (!method.isConstructor()) break block4;
                    return 0;
                }
                try {
                    if (method.getElementName().startsWith("create")) {
                        return 1;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return 10;
            }
        });
    }

    private void markSelectedMethod() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                NoEntryPointComposite.this.markSelectedMethodEx();
            }
        });
    }

    private void markSelectedMethodEx() throws Exception {
        IMethod methodModel = (IMethod)GenericsUtils.first((ISelection)this.m_viewer.getSelection());
        String methodSignature = CodeUtils.getMethodSignature(methodModel);
        MethodDeclaration method = AstNodeUtils.getMethodBySignature(this.m_typeDeclaration, methodSignature);
        this.m_editor.setJavadocTagText((BodyDeclaration)method, "@wbp.parser.entryPoint", "");
        this.m_editor.commitChanges();
    }
}

