/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.SegmentEvent;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.widgets.Control;

class BaseTextDirectionSegmentListener
implements SegmentListener {
    private final String textDirection;

    public BaseTextDirectionSegmentListener(String textDir) {
        this.textDirection = textDir;
    }

    public void getSegments(SegmentEvent event) {
        int length = event.lineText.length();
        if (length > 0) {
            boolean isRTL = this.isRTLValue(event.lineText);
            if (event.widget instanceof Control && Util.isWindows()) {
                if (isRTL) {
                    ((Control)event.widget).setOrientation(0x4000000);
                } else {
                    ((Control)event.widget).setOrientation(0x2000000);
                }
            } else {
                event.segments = new int[2];
                event.segments[0] = 0;
                event.segments[1] = length;
                (event.segmentsChars = new char[2])[0] = isRTL ? 8235 : 8234;
                event.segmentsChars[1] = 8236;
            }
        }
    }

    protected boolean isRTLValue(String stringValue) {
        if (stringValue == null || stringValue.isEmpty() || "ltr".equals(this.textDirection)) {
            return false;
        }
        if ("rtl".equals(this.textDirection)) {
            return true;
        }
        int i = 0;
        while (i < stringValue.length()) {
            if (Character.getDirectionality(stringValue.charAt(i)) == 1 || Character.getDirectionality(stringValue.charAt(i)) == 2 || Character.getDirectionality(stringValue.charAt(i)) == 6) {
                return true;
            }
            if (Character.getDirectionality(stringValue.charAt(i)) == 0) {
                return false;
            }
            ++i;
        }
        return false;
    }
}

