/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.PermutationType;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.ResolveSession;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class Logger {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private int m_logLevel = 1;

    public Logger(int i) {
        this.m_logLevel = i;
    }

    public final synchronized void setLogLevel(int i) {
        this.m_logLevel = i;
    }

    public final synchronized int getLogLevel() {
        return this.m_logLevel;
    }

    public final void log(int level, String msg) {
        this._log(level, msg, null);
    }

    public final void log(int level, String msg, Throwable throwable) {
        this._log(level, msg, throwable);
    }

    public boolean isDebugEnabled() {
        return this.m_logLevel >= 4;
    }

    public final void debug(String msg) {
        this._log(4, msg, null);
    }

    protected void doLog(int level, String msg, Throwable throwable) {
        if (level > this.m_logLevel) {
            return;
        }
        String s = msg;
        if (throwable != null) {
            s = String.valueOf(s) + " (" + throwable + ")";
        }
        switch (level) {
            case 4: {
                System.out.println("DEBUG: " + s);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + s);
                if (throwable == null) break;
                throwable.printStackTrace();
                break;
            }
            case 3: {
                System.out.println("INFO: " + s);
                break;
            }
            case 2: {
                System.out.println("WARNING: " + s);
                break;
            }
            default: {
                System.out.println("UNKNOWN[" + level + "]: " + s);
            }
        }
    }

    private void _log(int level, String msg, Throwable throwable) {
        if (this.m_logLevel >= level) {
            this.doLog(level, msg, throwable);
        }
    }

    public void logUsesConstraintViolation(Resource resource, ResolutionError error) {
    }

    public void logCandidates(Resource resource, Function<Requirement, List<Capability>> candidateLookup) {
    }

    public void logRequirement(String message, Requirement requirement) {
        this.debug(String.format(message, requirement));
    }

    public void logCapability(String message, Capability requirement) {
        this.debug(String.format(message, requirement));
    }

    public void logPermutationAdded(PermutationType type) {
    }

    public void logProcessPermutation(PermutationType type) {
    }

    public void logPermutationProcessed(ResolutionError error) {
    }

    void logCandidates(ResolveSession session, Candidates candidates) {
        Collection<Resource> mandatoryResources = session.getMandatoryResources();
        Collection<Resource> optionalResources = session.getOptionalResources();
        for (Resource resource : mandatoryResources) {
            this.logCandidates(resource, candidates);
        }
        for (Resource resource : optionalResources) {
            this.logCandidates(resource, candidates);
        }
    }

    private void logCandidates(Resource resource, Candidates candidates) {
        this.logCandidates(resource, (Requirement req) -> {
            List<Capability> list = candidates.getCandidates((Requirement)req);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        });
    }

    public String toString(Requirement requirement) {
        return String.valueOf(requirement);
    }

    public String toString(Capability capability) {
        return String.valueOf(capability);
    }
}

