/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DebugPluginImages {
    private static ImageRegistry imageRegistry;
    private static final String ATTR_LAUNCH_CONFIG_TYPE_ICON = "icon";
    private static final String ATTR_LAUNCH_CONFIG_TYPE_ID = "configTypeID";
    private static String ICONS_PATH;
    private static final String CTOOL;
    private static final String DTOOL;
    private static final String DLCL;
    private static final String ELCL;
    private static final String OBJECT;
    private static final String WIZBAN;
    private static final String OVR;
    private static final String VIEW;

    static {
        ICONS_PATH = "$nl$/icons/full/";
        CTOOL = ICONS_PATH + "etool16/";
        DTOOL = ICONS_PATH + "dtool16/";
        DLCL = ICONS_PATH + "dlcl16/";
        ELCL = ICONS_PATH + "elcl16/";
        OBJECT = ICONS_PATH + "obj16/";
        WIZBAN = ICONS_PATH + "wizban/";
        OVR = ICONS_PATH + "ovr16/";
        VIEW = ICONS_PATH + "eview16/";
    }

    private static void declareImages() {
        IConfigurationElement[] configElements;
        DebugPluginImages.declareRegistryImage("IMG_ACT_DEBUG", CTOOL + "debug_exc.png");
        DebugPluginImages.declareRegistryImage("IMG_ACT_RUN", CTOOL + "run_exc.png");
        DebugPluginImages.declareRegistryImage("IMG_ACT_SYNCED", ELCL + "synced.png");
        DebugPluginImages.declareRegistryImage("IMG_SKIP_BREAKPOINTS", ELCL + "skip_brkp.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_CHANGE_VARIABLE_VALUE", ELCL + "changevariablevalue_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_CHANGE_VARIABLE_VALUE", DLCL + "changevariablevalue_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_CHANGE_VARIABLE_VALUE", ELCL + "changevariablevalue_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_CONTENT_ASSIST", ELCL + "metharg_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_CONTENT_ASSIST", DLCL + "metharg_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_CONTENT_ASSIST", ELCL + "metharg_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DETAIL_PANE", ELCL + "toggledetailpane_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DETAIL_PANE_UNDER", ELCL + "det_pane_under.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DETAIL_PANE_RIGHT", ELCL + "det_pane_right.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DETAIL_PANE_HIDE", ELCL + "det_pane_hide.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_LOCK", ELCL + "lock_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_TYPE_NAMES", ELCL + "tnames_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DISCONNECT", ELCL + "disconnect_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_REMOVE_ALL", ELCL + "rem_all_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_REMOVE", ELCL + "rem_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_SHOW_LOGICAL_STRUCTURE", ELCL + "var_cntnt_prvdr.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_COLLAPSE_ALL", ELCL + "collapseall.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_TERMINATE", ELCL + "terminate_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_RUN_TO_LINE", ELCL + "runtoline_co.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_MONITOR_EXPRESSION", ELCL + "monitorexpression_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_REMOVE_MEMORY", ELCL + "removememory_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_RESET_MEMORY", ELCL + "memoryreset_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_COPY_VIEW_TO_CLIPBOARD", ELCL + "copyviewtoclipboard_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_LCL_PRINT_TOP_VIEW_TAB", ELCL + "printview_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE", DLCL + "toggledetailpane_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE_UNDER", DLCL + "det_pane_under.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE_RIGHT", DLCL + "det_pane_right.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE_HIDE", DLCL + "det_pane_hide.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE_AUTO", DLCL + "det_pane_auto.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_LOCK", DLCL + "lock_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_TYPE_NAMES", DLCL + "tnames_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_SHOW_LOGICAL_STRUCTURE", DLCL + "var_cntnt_prvdr.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_COLLAPSE_ALL", DLCL + "collapseall.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_TERMINATE", DLCL + "terminate_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_REMOVE_ALL", DLCL + "rem_all_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_REMOVE", DLCL + "rem_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_RUN_TO_LINE", DLCL + "runtoline_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_MONITOR_EXPRESSION", DLCL + "monitorexpression_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_REMOVE_MEMORY", DLCL + "removememory_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_RESET_MEMORY", DLCL + "memoryreset_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_COPY_VIEW_TO_CLIPBOARD", DLCL + "copyviewtoclipboard_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_PRINT_TOP_VIEW_TAB", DLCL + "printview_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DUPLICATE_CONFIG", DLCL + "copy_edit_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_NEW_CONFIG", DLCL + "new_con.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DELETE_CONFIG", DLCL + "rem_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_FILTER_CONFIGS", DLCL + "filter_ps.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_NEW_PROTO", DLCL + "new_proto.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_LINK_PROTO", DLCL + "link_proto.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_UNLINK_PROTO", DLCL + "unlink_proto.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_RESET_PROTO", DLCL + "reset_proto.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DISCONNECT", DLCL + "disconnect_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_SUSPEND", DLCL + "suspend_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_RESUME", DLCL + "resume_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_STEP_RETURN", DLCL + "stepreturn_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_STEP_OVER", DLCL + "stepover_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_STEP_INTO", DLCL + "stepinto_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_TERMINATE_AND_REMOVE", DLCL + "terminate_rem_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_TERMINATE_ALL", DLCL + "terminate_all_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_TERMINATE_AND_RELAUNCH", DTOOL + "term_restart.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_TOGGLE_STEP_FILTERS", DLCL + "stepbystep_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_NEXT_THREAD", DLCL + "next_thread_nav.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_PREVIOUS_THREAD", DLCL + "prev_thread_nav.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_RESTART", DLCL + "restart_co.png");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_EXPORT_CONFIG", DLCL + "export_config.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE", ELCL + "toggledetailpane_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE_UNDER", ELCL + "det_pane_under.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE_RIGHT", ELCL + "det_pane_right.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE_HIDE", ELCL + "det_pane_hide.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE_AUTO", ELCL + "det_pane_auto.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DEBUG_VIEW_BREADCRUMB_LAYOUT", ELCL + "debug_view_compact.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_LOCK", ELCL + "lock_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_TYPE_NAMES", ELCL + "tnames_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_SHOW_LOGICAL_STRUCTURE", ELCL + "var_cntnt_prvdr.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_COLLAPSE_ALL", ELCL + "collapseall.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_TERMINATE", ELCL + "terminate_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_MONITOR_EXPRESSION", ELCL + "monitorexpression_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_REMOVE_MEMORY", ELCL + "removememory_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_RESET_MEMORY", ELCL + "memoryreset_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_COPY_VIEW_TO_CLIPBOARD", ELCL + "copyviewtoclipboard_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_PRINT_TOP_VIEW_TAB", ELCL + "printview_tsk.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_REMOVE_ALL", ELCL + "rem_all_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_REMOVE", ELCL + "rem_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_HIERARCHICAL", ELCL + "hierarchicalLayout.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_FILTER_CONFIGS", ELCL + "filter_ps.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DUPLICATE_CONFIG", ELCL + "copy_edit_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_NEW_CONFIG", ELCL + "new_con.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DELETE_CONFIG", ELCL + "delete_config.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_NEW_PROTO", ELCL + "new_proto.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_LINK_PROTO", ELCL + "link_proto.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_UNLINK_PROTO", ELCL + "unlink_proto.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_RESET_PROTO", ELCL + "reset_proto.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_SUSPEND", ELCL + "suspend_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_RESUME", ELCL + "resume_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_STEP_RETURN", ELCL + "stepreturn_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_STEP_OVER", ELCL + "stepover_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_STEP_INTO", ELCL + "stepinto_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DROP_TO_FRAME", ELCL + "drop_to_frame.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_TERMINATE_AND_REMOVE", ELCL + "terminate_rem_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_TERMINATE_ALL", ELCL + "terminate_all_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_TERMINATE_AND_RELAUNCH", CTOOL + "term_restart.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_TOGGLE_STEP_FILTERS", ELCL + "stepbystep_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_STANDARD_OUT", ELCL + "writeout_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_STANDARD_ERR", ELCL + "writeerr_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_NEXT_THREAD", ELCL + "next_thread_nav.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_PREVIOUS_THREAD", ELCL + "prev_thread_nav.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_RESTART", ELCL + "restart_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_EXPORT_CONFIG", ELCL + "export_config.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_LAUNCH_DEBUG", OBJECT + "ldebug_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_LAUNCH_RUN", OBJECT + "lrun_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_LAUNCH_RUN_TERMINATED", OBJECT + "terminatedlaunch_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_DEBUG_TARGET", OBJECT + "debugt_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_DEBUG_TARGET_SUSPENDED", OBJECT + "debugts_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_DEBUG_TARGET_TERMINATED", OBJECT + "debugtt_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_THREAD_RUNNING", OBJECT + "thread_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_THREAD_SUSPENDED", OBJECT + "threads_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_THREAD_TERMINATED", OBJECT + "threadt_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_STACKFRAME", OBJECT + "stckframe_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_STACKFRAME_RUNNING", OBJECT + "stckframe_running_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_VARIABLE", OBJECT + "genericvariable_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_REGISTER", OBJECT + "genericregister_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_REGISTER_GROUP", OBJECT + "genericreggroup_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_BREAKPOINT", OBJECT + "brkp_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_BREAKPOINT_DISABLED", OBJECT + "brkpd_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_BREAKPOINT_GROUP", OBJECT + "brkp_grp.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_BREAKPOINT_GROUP_DISABLED", OBJECT + "brkp_grp_disabled.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_WATCHPOINT", OBJECT + "readwrite_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_WATCHPOINT_DISABLED", OBJECT + "readwrite_obj_disabled.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_ACCESS_WATCHPOINT", OBJECT + "read_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_ACCESS_WATCHPOINT_DISABLED", OBJECT + "read_obj_disabled.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_MODIFICATION_WATCHPOINT", OBJECT + "write_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_MODIFICATION_WATCHPOINT_DISABLED", OBJECT + "write_obj_disabled.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_OS_PROCESS", OBJECT + "osprc_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_OS_PROCESS_TERMINATED", OBJECT + "osprct_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_EXPRESSION", OBJECT + "expression_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_INSTRUCTION_POINTER_TOP", OBJECT + "inst_ptr_top.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_INSTRUCTION_POINTER", OBJECT + "inst_ptr.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_ARRAY_PARTITION", OBJECT + "arraypartition_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_ENV_VAR", OBJECT + "envvar_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJECT_MEMORY_CHANGED", OBJECT + "memorychanged_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJECT_MEMORY", OBJECT + "memory_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJ_BREAKPOINT_TYPE", OBJECT + "brkp_type.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJ_LAUNCH_GROUP", OBJECT + "lgroup_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_CHECK", OBJECT + "check.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_UNCHECK", OBJECT + "uncheck.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_COMMON_TAB", OBJECT + "common_tab.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_REFRESH_TAB", OBJECT + "refresh_tab.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_PERSPECTIVE_TAB", OBJECT + "persp_tab.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_ENVIRONMENT", OBJECT + "environment_obj.png");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_PROTO_TAB", OBJECT + "proto_tab.png");
        DebugPluginImages.declareRegistryImage("IMG_VIEW_BREAKPOINTS", VIEW + "breakpoint_view.png");
        DebugPluginImages.declareRegistryImage("IMG_VIEW_EXPRESSIONS", VIEW + "watchlist_view.png");
        DebugPluginImages.declareRegistryImage("IMG_VIEW_LAUNCHES", VIEW + "debug_view.png");
        DebugPluginImages.declareRegistryImage("IMG_VIEW_VARIABLES", VIEW + "variable_view.png");
        DebugPluginImages.declareRegistryImage("IMG_CVIEW_MEMORY_VIEW", VIEW + "memory_view.png");
        DebugPluginImages.declareRegistryImage("IMG_CVIEW_MODULES_VIEW", VIEW + "module_view.png");
        DebugPluginImages.declareRegistryImage("IMG_PERSPECTIVE_DEBUG", VIEW + "debug_persp.png");
        DebugPluginImages.declareRegistryImage("IMG_WIZBAN_DEBUG", WIZBAN + "debug_wiz.png");
        DebugPluginImages.declareRegistryImage("IMG_WIZBAN_RUN", WIZBAN + "run_wiz.png");
        DebugPluginImages.declareRegistryImage("IMG_WIZBAN_IMPORT_BREAKPOINTS", WIZBAN + "import_brkpts_wizban.png");
        DebugPluginImages.declareRegistryImage("IMG_WIZBAN_EXPORT_BREAKPOINTS", WIZBAN + "export_brkpts_wizban.png");
        DebugPluginImages.declareRegistryImage("IMG_WIZBAN_IMPORT_CONFIGS", WIZBAN + "import_config_wizban.png");
        DebugPluginImages.declareRegistryImage("IMG_WIZBAN_EXPORT_CONFIGS", WIZBAN + "export_config_wizban.png");
        DebugPluginImages.declareRegistryImage("IMG_OVR_ERROR", OVR + "error.png");
        DebugPluginImages.declareRegistryImage("IMG_OVR_TRANSPARENT", OVR + "transparent.png");
        DebugPluginImages.declareRegistryImage("IMG_OVR_SKIP_BREAKPOINT", OVR + "skip_breakpoint_ov.png");
        DebugPluginImages.declareRegistryImage("IMG_OVR_SHOW_LOGICAL_STRUCTURE", OVR + "var_cntnt_prvdr_ov.png");
        DebugPluginImages.declareRegistryImage("IMG_OVR_PROTOTYPE", OVR + "prototype.png");
        DebugPluginImages.declareRegistryImage("IMG_SRC_LOOKUP_MENU", ELCL + "edtsrclkup_co.png");
        DebugPluginImages.declareRegistryImage("IMG_SRC_LOOKUP_MENU_DISABLED", DLCL + "edtsrclkup_co.png");
        DebugPluginImages.declareRegistryImage("IMG_SRC_LOOKUP_MENU_ENABLED", ELCL + "edtsrclkup_co.png");
        DebugPluginImages.declareRegistryImage("IMG_SRC_LOOKUP_TAB", ELCL + "edtsrclkup_co.png");
        DebugPluginImages.declareRegistryImage("IMG_ADD_SRC_LOCATION", WIZBAN + "addsrcloc_wiz.png");
        DebugPluginImages.declareRegistryImage("IMG_EDIT_SRC_LOCATION", WIZBAN + "edtsrclkup_wiz.png");
        DebugPluginImages.declareRegistryImage("IMG_ADD_SRC_DIRECTORY", WIZBAN + "adddir_wiz.png");
        DebugPluginImages.declareRegistryImage("IMG_EDIT_SRC_DIRECTORY", WIZBAN + "editdir_wiz.png");
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "launchConfigurationTypeImages");
        IConfigurationElement[] iConfigurationElementArray = configElements = extensionPoint.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            String configTypeID;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            ImageDescriptor descriptor = DebugUIPlugin.getImageDescriptor(configElement, ATTR_LAUNCH_CONFIG_TYPE_ICON);
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            if ((configTypeID = configElement.getAttribute(ATTR_LAUNCH_CONFIG_TYPE_ID)) == null) {
                configTypeID = configElement.getAttribute("type");
            }
            imageRegistry.put(configTypeID, descriptor);
            ++n2;
        }
    }

    private static final void declareRegistryImage(String key, String path) {
        Bundle bundle = FrameworkUtil.getBundle(DebugPluginImages.class);
        if (bundle == null) {
            imageRegistry.put(key, ImageDescriptor.getMissingImageDescriptor());
        } else {
            imageRegistry.put(key, ImageDescriptor.createFromURLSupplier((boolean)true, () -> FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)path), null)));
        }
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            DebugPluginImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static synchronized boolean isInitialized() {
        return imageRegistry != null;
    }

    public static synchronized ImageRegistry initializeImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(DebugUIPlugin.getStandardDisplay());
            DebugPluginImages.declareImages();
        }
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return DebugPluginImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return DebugPluginImages.getImageRegistry().getDescriptor(key);
    }
}

