/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSource;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;

public class TmfConfigurationSourceManager {
    public static final String CONFIG_EXTENSION_POINT_ID = "org.eclipse.tracecompass.tmf.core.config";
    public static final String SOURCE_TYPE_ELEM = "source";
    public static final String SOURCE_ATTR = "class";
    private Map<ITmfConfigurationSourceType, ITmfConfigurationSource> fDescriptors = new ConcurrentHashMap<ITmfConfigurationSourceType, ITmfConfigurationSource>();
    private static @Nullable TmfConfigurationSourceManager fInstance;

    private TmfConfigurationSourceManager() {
    }

    public static synchronized TmfConfigurationSourceManager getInstance() {
        TmfConfigurationSourceManager instance = fInstance;
        if (instance == null) {
            instance = new TmfConfigurationSourceManager();
            instance.init();
            fInstance = instance;
        }
        return instance;
    }

    public synchronized void dispose() {
        this.fDescriptors.values().forEach(t -> t.dispose());
        this.fDescriptors.clear();
    }

    public List<ITmfConfigurationSourceType> getConfigurationSourceTypes() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.fDescriptors.keySet());
        return builder.build();
    }

    public @Nullable ITmfConfigurationSource getConfigurationSource(@Nullable String typeId) {
        ITmfConfigurationSourceType desc = this.getDescriptor(typeId);
        return desc == null ? null : this.fDescriptors.get(desc);
    }

    private @Nullable ITmfConfigurationSourceType getDescriptor(@Nullable String typeId) {
        if (typeId == null) {
            return null;
        }
        Optional<ITmfConfigurationSourceType> optional = this.fDescriptors.keySet().stream().filter(desc -> desc.getId().equals(typeId)).findAny();
        return optional.isEmpty() ? null : optional.get();
    }

    private void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(CONFIG_EXTENSION_POINT_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            String source;
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals(SOURCE_TYPE_ELEM) && (source = ce.getAttribute(SOURCE_ATTR)) != null) {
                ITmfConfigurationSource sourceInstance = null;
                try {
                    sourceInstance = (ITmfConfigurationSource)ce.createExecutableExtension(SOURCE_ATTR);
                }
                catch (CoreException e) {
                    Activator.logError("ITmfConfigurationSource cannot be instantiated.", e);
                }
                if (sourceInstance != null) {
                    this.fDescriptors.put(sourceInstance.getConfigurationSourceType(), sourceInstance);
                }
            }
            ++n2;
        }
    }
}

