/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICProjectDescriptionPreferences;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.core.runtime.preferences.DefaultScope;

public class CProjectDescriptionPreferences
implements ICProjectDescriptionPreferences {
    private static final String ATTR_CONFIG_RELATIONS = "configRelations";
    private static final String PREF_CPROJECTDESCRIPTION_CONFIG_RELATIONS_KEY = "cprojectdescription.configRelations";
    private boolean fIsReadOnly;
    private boolean fIsModified;
    private Integer fConfigRelations;
    private CProjectDescriptionPreferences fSuperPreference;

    CProjectDescriptionPreferences(CProjectDescriptionPreferences base, boolean isReadOnly) {
        this(base, base.fSuperPreference, isReadOnly);
    }

    CProjectDescriptionPreferences(CProjectDescriptionPreferences base, CProjectDescriptionPreferences superPreference, boolean isReadOnly) {
        this.fConfigRelations = base.fConfigRelations;
        this.fSuperPreference = superPreference;
        this.fIsReadOnly = isReadOnly;
    }

    CProjectDescriptionPreferences(ICStorageElement el, CProjectDescriptionPreferences superPreference, boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
        if (el != null && el.getAttribute(ATTR_CONFIG_RELATIONS) != null) {
            this.fConfigRelations = CDataUtil.getInteger(el, ATTR_CONFIG_RELATIONS, CProjectDescriptionPreferences.getDefaultRelations());
        }
        this.fSuperPreference = superPreference;
    }

    protected CProjectDescriptionPreferences getSuperPreferences() {
        if (this.isReadOnly()) {
            return this.fSuperPreference;
        }
        return (CProjectDescriptionPreferences)((Object)CProjectDescriptionManager.getInstance().getProjectDescriptionWorkspacePreferences(false));
    }

    void serialize(ICStorageElement el) {
        if (this.fConfigRelations != null) {
            CDataUtil.setInteger(el, ATTR_CONFIG_RELATIONS, this.fConfigRelations);
        }
    }

    public static int getDefaultRelations() {
        return DefaultScope.INSTANCE.getNode("org.eclipse.cdt.core").getInt(PREF_CPROJECTDESCRIPTION_CONFIG_RELATIONS_KEY, 2);
    }

    @Override
    public int getConfigurationRelations() {
        if (this.fConfigRelations != null) {
            return this.fConfigRelations;
        }
        CProjectDescriptionPreferences superPrefs = this.getSuperPreferences();
        if (superPrefs != null) {
            return superPrefs.getConfigurationRelations();
        }
        return CProjectDescriptionPreferences.getDefaultRelations();
    }

    @Override
    public boolean isDefaultConfigurationRelations() {
        return this.fConfigRelations == null;
    }

    @Override
    public void setConfigurationRelations(int status) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (this.fConfigRelations != null && this.fConfigRelations == status) {
            return;
        }
        this.fConfigRelations = status;
        this.fIsModified = true;
    }

    @Override
    public void useDefaultConfigurationRelations() {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (this.fConfigRelations == null) {
            return;
        }
        this.fConfigRelations = null;
        this.fIsModified = true;
    }

    public boolean isModified() {
        return this.fIsModified || this.fSuperPreference != null && !this.fSuperPreference.settingsEqual((CProjectDescriptionPreferences)((Object)CProjectDescriptionManager.getInstance().getProjectDescriptionWorkspacePreferences(false)));
    }

    void setModified(boolean modified) {
        this.fIsModified = modified;
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    void setReadOnly(boolean readOnly) {
        this.fIsReadOnly = readOnly;
    }

    public boolean settingsEqual(CProjectDescriptionPreferences other) {
        if (this.isDefaultConfigurationRelations() != other.isDefaultConfigurationRelations()) {
            return false;
        }
        return this.getConfigurationRelations() == other.getConfigurationRelations();
    }
}

