/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class TmfContext
implements ITmfContext {
    private @Nullable ITmfLocation fLocation;
    private long fRank;

    public TmfContext() {
        this(null, -1L);
    }

    public TmfContext(ITmfLocation location) {
        this(location, -1L);
    }

    public TmfContext(ITmfLocation location, long rank) {
        this.fLocation = location;
        this.fRank = rank;
    }

    public TmfContext(TmfContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.fLocation = context.fLocation;
        this.fRank = context.fRank;
    }

    @Override
    public @Nullable ITmfLocation getLocation() {
        return this.fLocation;
    }

    @Override
    public void setLocation(ITmfLocation location) {
        this.fLocation = location;
    }

    @Override
    public long getRank() {
        return this.fRank;
    }

    @Override
    public void setRank(long rank) {
        this.fRank = rank;
    }

    @Override
    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.fRank;
        }
    }

    @Override
    public boolean hasValidRank() {
        return this.fRank != -1L;
    }

    @Override
    public void dispose() {
    }

    public int hashCode() {
        return Objects.hash(this.fRank, this.fLocation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfContext other = (TmfContext)obj;
        if (this.fRank != other.fRank) {
            return false;
        }
        return Objects.equals(this.fLocation, other.fLocation);
    }

    public String toString() {
        return "TmfContext [fLocation=" + String.valueOf(this.fLocation) + ", fRank=" + this.fRank + "]";
    }
}

