/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.core.runtime.CoreException;

public class EvalFunctionSet
extends CPPDependentEvaluation {
    private final CPPFunctionSet fFunctionSet;
    private final boolean fQualified;
    private final boolean fAddressOf;
    private final IType fImpliedObjectType;
    private final char[] fName;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;
    private static final short FLAG_ADDRESS_OF = 32;
    private static final short FLAG_HAS_FUNCTION_SET = 64;
    private static final short FLAG_HAS_TEMPLATE_ARGS = 128;
    private static final short FLAG_QUALIFIED = 256;

    public EvalFunctionSet(CPPFunctionSet set, boolean qualified, boolean addressOf, IType impliedObjectType, IASTNode pointOfDefinition) {
        this(set, qualified, addressOf, impliedObjectType, EvalFunctionSet.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalFunctionSet(CPPFunctionSet set, boolean qualified, boolean addressOf, IType impliedObjectType, IBinding templateDefinition) {
        super(templateDefinition);
        this.fFunctionSet = set;
        this.fQualified = qualified;
        this.fAddressOf = addressOf;
        this.fImpliedObjectType = impliedObjectType;
        this.fName = null;
    }

    public EvalFunctionSet(char[] name, boolean qualified, boolean addressOf, IASTNode pointOfDefinition) {
        this(name, qualified, addressOf, EvalFunctionSet.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalFunctionSet(char[] name, boolean qualified, boolean addressOf, IBinding templateDefinition) {
        super(templateDefinition);
        this.fFunctionSet = null;
        this.fQualified = qualified;
        this.fAddressOf = addressOf;
        this.fImpliedObjectType = null;
        this.fName = name;
    }

    public CPPFunctionSet getFunctionSet() {
        return this.fFunctionSet;
    }

    public boolean isQualified() {
        return this.fQualified;
    }

    public boolean isAddressOf() {
        return this.fAddressOf;
    }

    public IType getImpliedObjectType() {
        return this.fImpliedObjectType;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return true;
    }

    @Override
    public boolean isTypeDependent() {
        int n;
        int n2;
        Object[] objectArray;
        if (this.fFunctionSet == null) {
            return true;
        }
        ICPPTemplateArgument[] args = this.fFunctionSet.getTemplateArguments();
        if (args != null) {
            objectArray = args;
            n2 = args.length;
            n = 0;
            while (n < n2) {
                Object arg = objectArray[n];
                if (CPPTemplates.isDependentArgument((ICPPTemplateArgument)arg)) {
                    return true;
                }
                ++n;
            }
        }
        objectArray = this.fFunctionSet.getBindings();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Object f = objectArray[n];
            if (f instanceof ICPPUnknownBinding) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean isValueDependent() {
        return this.isTypeDependent();
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression() {
        if (this.fFunctionSet == null) {
            return false;
        }
        ICPPFunction[] iCPPFunctionArray = this.fFunctionSet.getBindings();
        int n = iCPPFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction f = iCPPFunctionArray[n2];
            if (!f.isConstexpr()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalFunctionSet)) {
            return false;
        }
        EvalFunctionSet o = (EvalFunctionSet)other;
        if (this.fFunctionSet == null) {
            return o.fFunctionSet == null;
        }
        return this.fFunctionSet.equals(o.fFunctionSet);
    }

    @Override
    public IType getType() {
        return new FunctionSetType(this.fFunctionSet, this.fAddressOf);
    }

    @Override
    public IValue getValue() {
        return IntegralValue.UNKNOWN;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 9;
        if (this.fQualified) {
            firstBytes = (short)(firstBytes | 0x100);
        }
        if (this.fAddressOf) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.fFunctionSet != null) {
            firstBytes = (short)(firstBytes | 0x40);
            ICPPFunction[] bindings = this.fFunctionSet.getBindings();
            ICPPTemplateArgument[] args = this.fFunctionSet.getTemplateArguments();
            if (args != null) {
                firstBytes = (short)(firstBytes | 0x80);
            }
            buffer.putShort(firstBytes);
            buffer.putInt(bindings.length);
            Object[] objectArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPFunction binding = objectArray[n2];
                buffer.marshalBinding(binding);
                ++n2;
            }
            if (args != null) {
                buffer.putInt(args.length);
                objectArray = args;
                n = args.length;
                n2 = 0;
                while (n2 < n) {
                    Object arg = objectArray[n2];
                    buffer.marshalTemplateArgument((ICPPTemplateArgument)arg);
                    ++n2;
                }
            }
            buffer.marshalType(this.fImpliedObjectType);
        } else {
            buffer.putShort(firstBytes);
            buffer.putCharArray(this.fName);
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean addressOf;
        boolean qualified = (firstBytes & 0x100) != 0;
        boolean bl = addressOf = (firstBytes & 0x20) != 0;
        if ((firstBytes & 0x40) != 0) {
            int bindingCount = buffer.getInt();
            ICPPFunction[] bindings = new ICPPFunction[bindingCount];
            int i = 0;
            while (i < bindings.length) {
                bindings[i] = (ICPPFunction)buffer.unmarshalBinding();
                ++i;
            }
            ICPPTemplateArgument[] args = null;
            if ((firstBytes & 0x80) != 0) {
                int len = buffer.getInt();
                args = new ICPPTemplateArgument[len];
                int i2 = 0;
                while (i2 < args.length) {
                    args[i2] = buffer.unmarshalTemplateArgument();
                    ++i2;
                }
            }
            IType impliedObjectType = buffer.unmarshalType();
            IBinding templateDefinition = buffer.unmarshalBinding();
            return new EvalFunctionSet(new CPPFunctionSet(bindings, args, null), qualified, addressOf, impliedObjectType, templateDefinition);
        }
        char[] name = buffer.getCharArray();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalFunctionSet(name, qualified, addressOf, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPFunction[] originalFunctions;
        IType type;
        IBinding originalOwner;
        IBinding owner;
        Object[] originalArguments;
        if (this.fFunctionSet == null) {
            return this;
        }
        Object[] arguments = originalArguments = this.fFunctionSet.getTemplateArguments();
        if (originalArguments != null) {
            arguments = EvalFunctionSet.instantiateArguments((ICPPTemplateArgument[])originalArguments, context, true);
        }
        if ((owner = (originalOwner = this.fFunctionSet.getOwner())) instanceof ICPPUnknownBinding) {
            owner = EvalFunctionSet.resolveUnknown((ICPPUnknownBinding)owner, context);
        } else if (owner instanceof ICPPClassTemplate) {
            owner = EvalFunctionSet.resolveUnknown(CPPTemplates.createDeferredInstance((ICPPClassTemplate)owner), context);
        } else if (owner instanceof IType && (type = CPPTemplates.instantiateType((IType)((Object)owner), context)) instanceof IBinding) {
            owner = (IBinding)((Object)type);
        }
        ICPPFunction[] functions = originalFunctions = this.fFunctionSet.getBindings();
        if (owner instanceof ICPPClassSpecialization && owner != originalOwner) {
            ICPPClassSpecialization ownerClass = (ICPPClassSpecialization)owner;
            functions = new ICPPFunction[originalFunctions.length];
            int i = 0;
            while (i < originalFunctions.length) {
                functions[i] = (ICPPFunction)ownerClass.specializeMember(originalFunctions[i]);
                ++i;
            }
        }
        if (Arrays.equals(arguments, originalArguments) && functions == originalFunctions) {
            return this;
        }
        return new EvalFunctionSet(new CPPFunctionSet(functions, (ICPPTemplateArgument[])arguments, null), this.fQualified, this.fAddressOf, this.fImpliedObjectType, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this;
    }

    public ICPPEvaluation resolveFunction(ICPPEvaluation[] args) {
        LookupData data;
        ICPPFunction[] functions = null;
        IASTNode point = CPPSemantics.getCurrentLookupPoint();
        if (this.fFunctionSet == null) {
            data = new LookupData(this.fName, null, point);
        } else {
            functions = this.fFunctionSet.getBindings();
            data = new LookupData(functions[0].getNameCharArray(), this.fFunctionSet.getTemplateArguments(), point);
            data.foundItems = functions;
        }
        data.setFunctionArguments(false, args);
        if (this.fImpliedObjectType != null) {
            data.setImpliedObjectType(this.fImpliedObjectType);
        }
        try {
            IBinding binding;
            if (!this.fQualified && this.fImpliedObjectType == null && !data.hasTypeOrMemberFunctionOrVariableResult()) {
                CPPSemantics.doArgumentDependentLookup(data);
                Object[] foundItems = (Object[])data.foundItems;
                if (foundItems != null && (functions == null || foundItems.length > functions.length)) {
                    int start;
                    int i = start = functions == null ? 0 : functions.length;
                    while (i < foundItems.length) {
                        Object obj = foundItems[i];
                        if (obj instanceof ICPPFunction) {
                            functions = ArrayUtil.append(ICPPFunction.class, functions, (ICPPFunction)obj);
                        } else if (obj instanceof ICPPClassType) {
                            functions = ArrayUtil.addAll(ICPPFunction.class, functions, ((ICPPClassType)obj).getConstructors());
                        }
                        ++i;
                    }
                    functions = ArrayUtil.removeDuplicates(functions);
                }
            }
            if ((binding = CPPSemantics.resolveFunction(data, functions, true, true)) == null || binding instanceof IProblemBinding) {
                return EvalFixed.INCOMPLETE;
            }
            if (binding instanceof ICPPFunction && !(binding instanceof ICPPUnknownBinding)) {
                return new EvalBinding(binding, null, this.getTemplateDefinition());
            }
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
        }
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        ICPPTemplateArgument[] templateArguments;
        int r = Integer.MAX_VALUE;
        if (this.fFunctionSet != null && (templateArguments = this.fFunctionSet.getTemplateArguments()) != null) {
            ICPPTemplateArgument[] iCPPTemplateArgumentArray = templateArguments;
            int n = templateArguments.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
                r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(arg, tpMap));
                ++n2;
            }
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }

    @Override
    public boolean isNoexcept() {
        assert (false);
        return true;
    }
}

