/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;

public final class SafeMappedByteBuffer {
    private static final boolean IS_WIN32 = System.getProperty("os.name").startsWith("Windows");

    private SafeMappedByteBuffer() {
    }

    public static @NonNull ByteBuffer map(FileChannel fc, FileChannel.MapMode mode, long position, long size) throws IOException, CTFException {
        ByteBuffer byteBuffer = null;
        long fileSize = fc.size();
        if (IS_WIN32) {
            byteBuffer = ByteBuffer.allocate((int)size);
            fc.read(byteBuffer, position);
            byteBuffer.flip();
        } else {
            if (position + size <= fileSize) {
                byteBuffer = fc.map(mode, position, size);
            }
            if (byteBuffer == null) {
                throw new CTFException("Failed to allocate mapped byte buffer at " + position + " of size " + size + " on a file of size " + fileSize);
            }
        }
        return byteBuffer;
    }
}

