/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.shadows;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.shadows.EllipseDropShadowBorder;
import org.eclipse.draw2d.shadows.RectangleDropShadowBorder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;

public class ShadowsExample
extends AbstractExample {
    public static void main(String[] args) {
        new ShadowsExample().run();
    }

    @Override
    protected IFigure createContents() {
        Figure panel = new Figure();
        panel.add(ShadowsExample.createPage());
        panel.add(ShadowsExample.createRectangleFigure(480, 40, 50, 30, ColorConstants.green));
        panel.add(ShadowsExample.createRectangleFigure(480, 230, 50, 30, ColorConstants.black));
        return panel;
    }

    @Override
    protected void hookShell(Shell shell) {
        this.getFigureCanvas().setSize(600, 500);
    }

    private static IFigure createCircleFigure(int x, int y, int r, Color color) {
        Figure circle = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                graphics.fillOval(this.getBounds());
            }
        };
        circle.setBounds(new Rectangle(x - r, y - r, 2 * r, 2 * r));
        circle.setBackgroundColor(color);
        circle.setBorder((Border)new EllipseDropShadowBorder());
        return circle;
    }

    private static IFigure createPage() {
        IFigure page = ShadowsExample.createRectangleFigure(10, 10, 350, 420, ColorConstants.white);
        RectangleDropShadowBorder pageBorder = new RectangleDropShadowBorder();
        pageBorder.setDropShadowSize(12);
        pageBorder.setHaloSize(6);
        pageBorder.setSoftness(4.5);
        page.setBorder((Border)pageBorder);
        page.add(ShadowsExample.createCircleFigure(40, 40, 20, ColorConstants.darkBlue));
        page.add(ShadowsExample.createRoundedRectangleFigure(150, 45, 120, 100, 10, ColorConstants.button));
        page.add(ShadowsExample.createRectangleFigure(200, 200, 120, 75, ColorConstants.cyan));
        page.add(ShadowsExample.createRectangleFigure(75, 300, 200, 100, ColorConstants.lightGreen));
        return page;
    }

    private static IFigure createRectangleFigure(int x, int y, int w, int h, Color color) {
        Figure circle = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                graphics.fillRectangle(this.getBounds());
            }
        };
        circle.setBounds(new Rectangle(x, y, w, h));
        circle.setBackgroundColor(color);
        circle.setBorder((Border)new RectangleDropShadowBorder());
        return circle;
    }

    private static IFigure createRoundedRectangleFigure(int x, int y, int w, int h, final int cornerRadius, Color color) {
        Figure circle = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                graphics.fillRoundRectangle(this.getBounds(), cornerRadius, cornerRadius);
            }
        };
        circle.setBounds(new Rectangle(x, y, w, h));
        circle.setBackgroundColor(color);
        circle.setBorder((Border)new RectangleDropShadowBorder(cornerRadius));
        return circle;
    }
}

