/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.path;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ZoomFigure
extends Figure
implements ScalableFigure {
    private double scale = 1.0;

    protected void paintClientArea(Graphics g) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        if (this.scale == 1.0) {
            super.paintClientArea(g);
        } else {
            if (!this.optimizeClip()) {
                g.clipRect(this.getBounds().getShrinked(this.getInsets()));
            }
            g.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
            g.scale(this.scale);
            g.pushState();
            this.paintChildren(g);
            g.popState();
            g.restoreState();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.repaint();
    }

    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        rect.width = (int)((double)rect.width / this.scale);
        rect.height = (int)((double)rect.height / this.scale);
        return rect;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    public void translateToParent(Translatable t) {
        t.performScale(this.scale);
        super.translateToParent(t);
    }

    public void translateFromParent(Translatable t) {
        super.translateFromParent(t);
        t.performScale(1.0 / this.scale);
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

