/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class MoveGuideCommand
extends Command {
    private int pDelta;
    private LogicGuide guide;

    public MoveGuideCommand(LogicGuide guide, int positionDelta) {
        super(LogicMessages.MoveGuideCommand_Label);
        this.guide = guide;
        this.pDelta = positionDelta;
    }

    public void execute() {
        this.guide.setPosition(this.guide.getPosition() + this.pDelta);
        for (LogicSubpart part : this.guide.getParts()) {
            Point location = part.getLocation().getCopy();
            if (this.guide.isHorizontal()) {
                location.y += this.pDelta;
            } else {
                location.x += this.pDelta;
            }
            part.setLocation(location);
        }
    }

    public void undo() {
        this.guide.setPosition(this.guide.getPosition() - this.pDelta);
        for (LogicSubpart part : this.guide.getParts()) {
            Point location = part.getLocation().getCopy();
            if (this.guide.isHorizontal()) {
                location.y -= this.pDelta;
            } else {
                location.x -= this.pDelta;
            }
            part.setLocation(location);
        }
    }
}

