/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.handlers;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.examples.logicdesigner.edit.GraphicalPartFactory;
import org.eclipse.gef.examples.logicdesigner.handlers.PrintModeDialog;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class LogicPrintHandler
extends AbstractHandler {
    private static ILog LOGGER = Platform.getLog(LogicPrintHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object object;
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        IFile selectedFile = (IFile)selection.getFirstElement();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ObjectInputStream ois = new ObjectInputStream(selectedFile.getContents(false));){
                object = ois.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException | CoreException e) {
            LOGGER.error(e.getMessage(), e);
            return null;
        }
        int style = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getStyle();
        Shell shell = new Shell((style & 0x8000000) != 0 ? 0x4000000 : 0);
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl((Composite)shell);
        viewer.setEditDomain((EditDomain)new DefaultEditDomain(null));
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        viewer.setContents(object);
        viewer.flush();
        int printMode = new PrintModeDialog(shell).open();
        if (printMode == -1) {
            return null;
        }
        PrintDialog dialog = new PrintDialog(shell, 0);
        PrinterData data = dialog.open();
        if (data != null) {
            PrintGraphicalViewerOperation op = new PrintGraphicalViewerOperation(new Printer(data), (GraphicalViewer)viewer);
            op.setPrintMode(printMode);
            op.run(selectedFile.getName());
        }
        return null;
    }
}

