/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Point;

public class NodeFigure
extends Figure {
    protected static final int ALPHA_OPAQUE = 255;
    protected static final int ALPHA_FEEDBACK = 100;
    private int alpha = 255;
    protected Map<String, ConnectionAnchor> connectionAnchors = new HashMap<String, ConnectionAnchor>(7);
    protected List<ConnectionAnchor> inputConnectionAnchors = new ArrayList<ConnectionAnchor>(2);
    protected List<ConnectionAnchor> outputConnectionAnchors = new ArrayList<ConnectionAnchor>(2);

    public ConnectionAnchor connectionAnchorAt(Point p) {
        long d;
        Point p2;
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        for (ConnectionAnchor c : this.getSourceConnectionAnchors()) {
            p2 = c.getLocation(null);
            d = p.getDistanceSquared(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        for (ConnectionAnchor c : this.getTargetConnectionAnchors()) {
            p2 = c.getLocation(null);
            d = p.getDistanceSquared(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        return this.connectionAnchors.get(terminal);
    }

    public String getConnectionAnchorName(ConnectionAnchor c) {
        for (Map.Entry<String, ConnectionAnchor> entry : this.connectionAnchors.entrySet()) {
            if (!entry.getValue().equals(c)) continue;
            return entry.getKey();
        }
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        for (ConnectionAnchor c : this.getSourceConnectionAnchors()) {
            Point p2 = c.getLocation(null);
            long d = p.getDistanceSquared(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public List<ConnectionAnchor> getSourceConnectionAnchors() {
        return this.outputConnectionAnchors;
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        for (ConnectionAnchor c : this.getTargetConnectionAnchors()) {
            Point p2 = c.getLocation(null);
            long d = p.getDistanceSquared(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public List<ConnectionAnchor> getTargetConnectionAnchors() {
        return this.inputConnectionAnchors;
    }

    protected final void setAlpha(int alpha) throws IllegalArgumentException {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha value must be between [0, 255]: %d".formatted(alpha));
        }
        this.alpha = alpha;
    }

    protected final int getAlpha() {
        return this.alpha;
    }
}

