/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ui.pde.internal.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.gef.examples.ui.pde.internal.GefExamplesPlugin;
import org.eclipse.gef.examples.ui.pde.internal.l10n.Messages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class ProjectUnzipperNewWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String ORG_ECLIPSE_JDT_CORE_JAVANATURE = "org.eclipse.jdt.core.javanature";
    private static final String ORG_ECLIPSE_PDE_PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private WizardNewProjectCreationPage wizardNewProjectCreationPage;
    private final String pageName;
    private final String pageTitle;
    private final String pageDescription;
    private final String pageProjectName;
    private final URL[] projectZipURL;
    private final String[] nameFormats;
    private IConfigurationElement config;

    protected ProjectUnzipperNewWizard(String pageNameIn, String pageTitleIn, String pageDescriptionIn, String pageProjectNameIn, URL projectZipURLIn) {
        this(pageNameIn, pageTitleIn, pageDescriptionIn, pageProjectNameIn, new URL[]{projectZipURLIn}, new String[]{"{0}"});
    }

    protected ProjectUnzipperNewWizard(String pageNameIn, String pageTitleIn, String pageDescriptionIn, String pageProjectNameIn, URL[] projectZipURLListIn, String[] nameFormatsIn) {
        this.pageName = pageNameIn;
        this.pageTitle = pageTitleIn;
        this.pageDescription = pageDescriptionIn;
        this.pageProjectName = pageProjectNameIn;
        this.projectZipURL = projectZipURLListIn;
        this.nameFormats = nameFormatsIn;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InterruptedException {
                    try {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.monitor_creatingProject, (int)(140 * ProjectUnzipperNewWizard.this.nameFormats.length));
                        IPath projectPath = ProjectUnzipperNewWizard.this.wizardNewProjectCreationPage.getLocationPath();
                        int i = 0;
                        while (i < ProjectUnzipperNewWizard.this.nameFormats.length) {
                            String projectName = MessageFormat.format(ProjectUnzipperNewWizard.this.nameFormats[i], ProjectUnzipperNewWizard.this.wizardNewProjectCreationPage.getProjectName());
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IProject project = workspace.getRoot().getProject(projectName);
                            if (!project.exists()) {
                                ProjectUnzipperNewWizard.createProject(subMonitor, projectPath, project, ProjectUnzipperNewWizard.this.getProjectZipURL()[i]);
                            }
                            project.open((IProgressMonitor)subMonitor.newChild(10));
                            ProjectUnzipperNewWizard.renameProject(project, projectName);
                            IProjectDescription desc = workspace.newProjectDescription(project.getName());
                            desc.setNatureIds(new String[]{ProjectUnzipperNewWizard.ORG_ECLIPSE_PDE_PLUGIN_NATURE, ProjectUnzipperNewWizard.ORG_ECLIPSE_JDT_CORE_JAVANATURE});
                            project.setDescription(desc, (IProgressMonitor)subMonitor.newChild(10));
                            if (subMonitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.getConfigurationElement());
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (Exception e) {
            GefExamplesPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gef.examples.ui.pde", 0, e.getMessage(), (Throwable)e));
            return false;
        }
        return true;
    }

    private static void createProject(SubMonitor subMonitor, IPath projectPath, IProject project, URL projectZipUrl) throws IOException, InterruptedException, CoreException {
        String projectFolder = projectPath.toOSString() + File.separator + project.getName();
        File projectFolderFile = new File(projectFolder);
        projectFolderFile.mkdirs();
        subMonitor.worked(10);
        ProjectUnzipperNewWizard.extractProject(projectFolderFile, projectZipUrl, (IProgressMonitor)subMonitor.newChild(100));
        if (subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (projectPath.equals((Object)project.getWorkspace().getRoot().getLocation())) {
            project.create((IProgressMonitor)subMonitor.newChild(10));
        } else {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation((IPath)new Path(projectFolder));
            project.create(desc, (IProgressMonitor)subMonitor.newChild(10));
        }
    }

    private static void extractProject(File projectFolderFile, URL url, IProgressMonitor monitor) throws IOException, InterruptedException {
        URL urlZipLocal = FileLocator.toFileURL((URL)url);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ZipFile zipFile = new ZipFile(urlZipLocal.getPath());){
                monitor.beginTask(Messages.monitor_unzippingProject, zipFile.size());
                ProjectUnzipperNewWizard.unzip(zipFile, projectFolderFile, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void unzip(ZipFile zipFile, File projectFolderFile, IProgressMonitor monitor) throws IOException, InterruptedException {
        e = zipFile.entries();
        while (e.hasMoreElements()) {
            block37: {
                zipEntry = e.nextElement();
                file = new File(projectFolderFile, zipEntry.getName());
                if (!zipEntry.isDirectory()) {
                    parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    if ((path = new Path(file.getPath())).getFileExtension().equals("java")) {
                        var8_8 = null;
                        var9_11 = null;
                        try {
                            is = new InputStreamReader(zipFile.getInputStream(zipEntry), StandardCharsets.UTF_8);
                            try {
                                os = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ResourcesPlugin.getEncoding());
                                try {
                                    is.transferTo((Writer)os);
                                }
                                finally {
                                    if (os != null) {
                                        os.close();
                                    }
                                }
                                ** if (is == null) goto lbl-1000
                            }
                            catch (Throwable var9_12) {
                                if (var8_8 == null) {
                                    var8_8 = var9_12;
                                } else if (var8_8 != var9_12) {
                                    var8_8.addSuppressed(var9_12);
                                }
                                if (is != null) {
                                    is.close();
                                }
                                throw var8_8;
                            }
lbl-1000:
                            // 1 sources

                            {
                                is.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block37;
                            }
                        }
                        catch (Throwable var9_13) {
                            if (var8_8 == null) {
                                var8_8 = var9_13;
                            } else if (var8_8 != var9_13) {
                                var8_8.addSuppressed(var9_13);
                            }
                            throw var8_8;
                        }
                    }
                    var8_8 = null;
                    var9_11 = null;
                    try {
                        is = zipFile.getInputStream(zipEntry);
                        try {
                            os = new FileOutputStream(file);
                            try {
                                is.transferTo((OutputStream)os);
                            }
                            finally {
                                if (os != null) {
                                    os.close();
                                }
                            }
                            ** if (is == null) goto lbl-1000
                        }
                        catch (Throwable var9_14) {
                            if (var8_8 == null) {
                                var8_8 = var9_14;
                            } else if (var8_8 != var9_14) {
                                var8_8.addSuppressed(var9_14);
                            }
                            if (is != null) {
                                is.close();
                            }
                            throw var8_8;
                        }
lbl-1000:
                        // 1 sources

                        {
                            is.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Throwable var9_15) {
                        if (var8_8 == null) {
                            var8_8 = var9_15;
                        } else if (var8_8 != var9_15) {
                            var8_8.addSuppressed(var9_15);
                        }
                        throw var8_8;
                    }
                }
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
    }

    private static void renameProject(IProject project, String projectName) throws CoreException {
        IProjectDescription description = project.getDescription();
        description.setName(projectName);
        project.move(description, 33, null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.wizardNewProjectCreationPage = new WizardNewProjectCreationPage(this.getPageName());
        this.wizardNewProjectCreationPage.setTitle(this.getPageTitle());
        this.wizardNewProjectCreationPage.setDescription(this.getPageDescription());
        this.wizardNewProjectCreationPage.setInitialProjectName(this.getPageProjectName());
        this.addPage((IWizardPage)this.wizardNewProjectCreationPage);
    }

    private String getPageName() {
        return this.pageName;
    }

    private String getPageTitle() {
        return this.pageTitle;
    }

    private String getPageDescription() {
        return this.pageDescription;
    }

    private String getPageProjectName() {
        return this.pageProjectName;
    }

    private URL[] getProjectZipURL() {
        return this.projectZipURL;
    }

    private IConfigurationElement getConfigurationElement() {
        return this.config;
    }

    public void setInitializationData(IConfigurationElement configIn, String propertyName, Object data) throws CoreException {
        this.config = configIn;
    }
}

