/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.palette;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.examples.Messages;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.util.IToolTipHelperFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.component.annotations.Component;

public class PaletteSnippet2
extends ViewPart {
    private static final Font BOLD_FONT = new Font(null, "Arial", 12, 1);
    private final PaletteRoot paletteRoot;
    private PaletteViewer paletteViewer;

    public PaletteSnippet2() {
        PaletteDrawer paletteDrawer = new PaletteDrawer(Messages.PaletteSnippet2_System);
        paletteDrawer.setDescription(Messages.PaletteSnippet2_System_Desc);
        SelectionToolEntry paletteEntry = new SelectionToolEntry();
        paletteEntry.setDescription(Messages.PaletteSnippet2_Selection_Desc);
        paletteDrawer.add((PaletteEntry)paletteEntry);
        this.paletteRoot = new PaletteRoot();
        this.paletteRoot.add((PaletteEntry)paletteDrawer);
    }

    public void createPartControl(Composite parent) {
        this.paletteViewer = new CustomPaletteViewer();
        this.paletteViewer.createControl(parent);
        this.paletteViewer.setPaletteRoot(this.paletteRoot);
    }

    public void setFocus() {
        if (this.paletteViewer != null) {
            this.paletteViewer.getControl().setFocus();
        }
    }

    public static class CustomPaletteViewer
    extends PaletteViewer {
    }

    public static class CustomToolTipHelper
    extends ToolTipHelper {
        private final EditPartViewer viewer;

        public CustomToolTipHelper(Control c, EditPartViewer viewer) {
            super(c);
            this.viewer = viewer;
        }

        public void displayToolTipNear(IFigure hoverSource, IFigure tip, int eventX, int eventY) {
            IFigure figureToShow = this.createCustomToolTip(hoverSource);
            if (figureToShow == null) {
                figureToShow = tip;
            }
            super.displayToolTipNear(hoverSource, figureToShow, eventX, eventY);
        }

        /*
         * WARNING - void declaration
         */
        private IFigure createCustomToolTip(IFigure hoverSource) {
            void paletteEntry;
            Object object;
            EditPart editPart = this.findEditPart(hoverSource);
            if (editPart == null || !((object = editPart.getModel()) instanceof PaletteEntry)) {
                return null;
            }
            PaletteEntry paletteEntry2 = (PaletteEntry)object;
            Figure customFigure = new Figure();
            customFigure.setLayoutManager((LayoutManager)new GridLayout());
            Label label1 = new Label(paletteEntry.getLabel());
            label1.setFont(BOLD_FONT);
            customFigure.add((IFigure)label1, (Object)new GridData(4, 4, true, false));
            Label label2 = new Label(paletteEntry.getDescription());
            customFigure.add((IFigure)label2, (Object)new GridData(4, 4, true, true));
            return customFigure;
        }

        private EditPart findEditPart(IFigure fig) {
            EditPart editPart = (EditPart)this.viewer.getVisualPartMap().get(fig);
            if (editPart != null) {
                return editPart;
            }
            if (fig.getParent() != null) {
                return this.findEditPart(fig.getParent());
            }
            return null;
        }
    }

    @Component
    public static class PaletteToolTipHelperFactory
    implements IToolTipHelperFactory {
        public ToolTipHelper create(Control control, EditPartViewer viewer) {
            if (viewer.getClass() == CustomPaletteViewer.class) {
                return new CustomToolTipHelper(control, viewer);
            }
            return null;
        }
    }
}

